/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;

public class LinearRing
extends LineString {
    private static final long serialVersionUID = -4261142084085851829L;

    public LinearRing(Coordinate[] points, PrecisionModel precisionModel, int SRID) {
        this(points, new GeometryFactory(precisionModel, SRID));
        this.validateConstruction();
    }

    private LinearRing(Coordinate[] points, GeometryFactory factory) {
        this(factory.getCoordinateSequenceFactory().create(points), factory);
    }

    public LinearRing(CoordinateSequence points, GeometryFactory factory) {
        super(points, factory);
        this.validateConstruction();
    }

    private void validateConstruction() {
        if (!this.isEmpty() && !super.isClosed()) {
            throw new IllegalArgumentException("Points of LinearRing do not form a closed linestring");
        }
        if (this.getCoordinateSequence().size() >= 1 && this.getCoordinateSequence().size() <= 3) {
            throw new IllegalArgumentException("Invalid number of points in LinearRing (found " + this.getCoordinateSequence().size() + " - must be 0 or >= 4)");
        }
    }

    public int getBoundaryDimension() {
        return -1;
    }

    public boolean isSimple() {
        return true;
    }

    public String getGeometryType() {
        return "LinearRing";
    }

    public Geometry reverse() {
        CoordinateSequence seq = (CoordinateSequence)this.points.clone();
        CoordinateSequences.reverse(seq);
        LinearRing rev = this.getFactory().createLinearRing(seq);
        return rev;
    }
}

