/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLShape;

public class PlaceFireStationTool
extends ShapeTool {
    public PlaceFireStationTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Place fire station";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return shape instanceof GMLBuilding;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().addFireStation(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new AddFireStationEdit(shape.getID()));
    }

    private class AddFireStationEdit
    extends AbstractUndoableEdit {
        private int id;

        public AddFireStationEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            PlaceFireStationTool.this.editor.getScenario().removeFireStation(this.id);
            PlaceFireStationTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            PlaceFireStationTool.this.editor.getScenario().addFireStation(this.id);
            PlaceFireStationTool.this.editor.updateOverlays();
        }
    }
}

