/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLShape;

public class PlacePoliceOfficeTool
extends ShapeTool {
    public PlacePoliceOfficeTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Place police office";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return shape instanceof GMLBuilding;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().addPoliceOffice(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new AddPoliceOfficeEdit(shape.getID()));
    }

    private class AddPoliceOfficeEdit
    extends AbstractUndoableEdit {
        private int id;

        public AddPoliceOfficeEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            PlacePoliceOfficeTool.this.editor.getScenario().removePoliceOffice(this.id);
            PlacePoliceOfficeTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            PlacePoliceOfficeTool.this.editor.getScenario().addPoliceOffice(this.id);
            PlacePoliceOfficeTool.this.editor.updateOverlays();
        }
    }
}

