/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLShape;

public class RemoveFireBrigadeTool
extends ShapeTool {
    public RemoveFireBrigadeTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Remove fire brigade";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return true;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().removeFireBrigade(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new RemoveFireBrigadeEdit(shape.getID()));
    }

    private class RemoveFireBrigadeEdit
    extends AbstractUndoableEdit {
        private int id;

        public RemoveFireBrigadeEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            RemoveFireBrigadeTool.this.editor.getScenario().addFireBrigade(this.id);
            RemoveFireBrigadeTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            RemoveFireBrigadeTool.this.editor.getScenario().removeFireBrigade(this.id);
            RemoveFireBrigadeTool.this.editor.updateOverlays();
        }
    }
}

