/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLShape;

public class RemovePoliceOfficeTool
extends ShapeTool {
    public RemovePoliceOfficeTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Remove police office";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return shape instanceof GMLBuilding;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().removePoliceOffice(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new RemovePoliceOfficeEdit(shape.getID()));
    }

    private class RemovePoliceOfficeEdit
    extends AbstractUndoableEdit {
        private int id;

        public RemovePoliceOfficeEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            RemovePoliceOfficeTool.this.editor.getScenario().addPoliceOffice(this.id);
            RemovePoliceOfficeTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            RemovePoliceOfficeTool.this.editor.getScenario().removePoliceOffice(this.id);
            RemovePoliceOfficeTool.this.editor.updateOverlays();
        }
    }
}

