/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi;

import com.infomatiq.jsi.Point;
import java.util.Arrays;

public class Rectangle {
    public static final int DIMENSIONS = 2;
    public float[] max;
    public float[] min;

    public Rectangle(float x1, float y1, float x2, float y2) {
        this.min = new float[2];
        this.max = new float[2];
        this.set(x1, y1, x2, y2);
    }

    public Rectangle(float[] min, float[] max) {
        if (min.length != 2 || max.length != 2) {
            throw new RuntimeException("Error in Rectangle constructor: min and max arrays must be of length 2");
        }
        this.min = new float[2];
        this.max = new float[2];
        this.set(min, max);
    }

    public void set(float x1, float y1, float x2, float y2) {
        this.min[0] = Math.min(x1, x2);
        this.min[1] = Math.min(y1, y2);
        this.max[0] = Math.max(x1, x2);
        this.max[1] = Math.max(y1, y2);
    }

    public void set(float[] min, float[] max) {
        System.arraycopy(min, 0, this.min, 0, 2);
        System.arraycopy(max, 0, this.max, 0, 2);
    }

    public Rectangle copy() {
        return new Rectangle(this.min, this.max);
    }

    public boolean edgeOverlaps(Rectangle r) {
        for (int i = 0; i < 2; ++i) {
            if (this.min[i] != r.min[i] && this.max[i] != r.max[i]) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Rectangle r) {
        for (int i = 0; i < 2; ++i) {
            if (!(this.max[i] < r.min[i]) && !(this.min[i] > r.max[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Rectangle r) {
        for (int i = 0; i < 2; ++i) {
            if (!(this.max[i] < r.max[i]) && !(this.min[i] > r.min[i])) continue;
            return false;
        }
        return true;
    }

    public boolean containedBy(Rectangle r) {
        for (int i = 0; i < 2; ++i) {
            if (!(this.max[i] > r.max[i]) && !(this.min[i] < r.min[i])) continue;
            return false;
        }
        return true;
    }

    public float distance(Point p) {
        float distanceSquared = 0.0f;
        for (int i = 0; i < 2; ++i) {
            float leastMax;
            float greatestMin = Math.max(this.min[i], p.coordinates[i]);
            if (!(greatestMin > (leastMax = Math.min(this.max[i], p.coordinates[i])))) continue;
            distanceSquared += (greatestMin - leastMax) * (greatestMin - leastMax);
        }
        return (float)Math.sqrt(distanceSquared);
    }

    public float distance(Rectangle r) {
        float distanceSquared = 0.0f;
        for (int i = 0; i < 2; ++i) {
            float leastMax;
            float greatestMin = Math.max(this.min[i], r.min[i]);
            if (!(greatestMin > (leastMax = Math.min(this.max[i], r.max[i])))) continue;
            distanceSquared += (greatestMin - leastMax) * (greatestMin - leastMax);
        }
        return (float)Math.sqrt(distanceSquared);
    }

    private float distanceSquared(int dimension, float point) {
        float distanceSquared = 0.0f;
        float tempDistance = point - this.max[dimension];
        for (int i = 0; i < 2; ++i) {
            if (tempDistance > 0.0f) {
                distanceSquared = tempDistance * tempDistance;
                break;
            }
            tempDistance = this.min[dimension] - point;
        }
        return distanceSquared;
    }

    public float furthestDistance(Rectangle r) {
        float distanceSquared = 0.0f;
        for (int i = 0; i < 2; ++i) {
            distanceSquared += Math.max(this.distanceSquared(i, r.min[i]), this.distanceSquared(i, r.max[i]));
        }
        return (float)Math.sqrt(distanceSquared);
    }

    public float enlargement(Rectangle r) {
        float enlargedArea = (Math.max(this.max[0], r.max[0]) - Math.min(this.min[0], r.min[0])) * (Math.max(this.max[1], r.max[1]) - Math.min(this.min[1], r.min[1]));
        return enlargedArea - this.area();
    }

    public float area() {
        return (this.max[0] - this.min[0]) * (this.max[1] - this.min[1]);
    }

    public void add(Rectangle r) {
        for (int i = 0; i < 2; ++i) {
            if (r.min[i] < this.min[i]) {
                this.min[i] = r.min[i];
            }
            if (!(r.max[i] > this.max[i])) continue;
            this.max[i] = r.max[i];
        }
    }

    public Rectangle union(Rectangle r) {
        Rectangle union = this.copy();
        union.add(r);
        return union;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof Rectangle) {
            Rectangle r = (Rectangle)o;
            if (Arrays.equals(r.min, this.min) && Arrays.equals(r.max, this.max)) {
                equals = true;
            }
        }
        return equals;
    }

    public boolean sameObject(Object o) {
        return super.equals(o);
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (i = 0; i < 2; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.min[i]);
        }
        sb.append("), (");
        for (i = 0; i < 2; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.max[i]);
        }
        sb.append(')');
        return sb.toString();
    }
}

