/*
 * Decompiled with CFR 0.152.
 */
package firesimulator.world;

import firesimulator.world.RealObject;
import firesimulator.world.RescueObject;
import firesimulator.world.StationaryObject;
import firesimulator.world.World;

public abstract class MovingObject
extends RealObject {
    private int stamina = 0;
    private int hp = 0;
    private int damage = 0;
    private int buriedness = 0;
    private int positionId = 0;
    private int positionExtra = 0;
    private RescueObject position;
    private World world = null;
    private String currentAction = "AK_REST";
    private int currentActionLastChange = 0;
    private int x;
    private int y;

    public MovingObject(int id) {
        super(id);
    }

    public void setWorld(World w) {
        this.world = w;
    }

    public void setPositionId(int id) {
        this.positionId = id;
        if (this.world != null) {
            this.position = this.world.getObject(this.positionId);
        }
    }

    public int getPositionId() {
        return this.positionId;
    }

    public void setPositionExtra(int pos) {
        this.positionExtra = pos;
    }

    public int getPositionExtra() {
        return this.positionExtra;
    }

    public void setPosition() {
    }

    public StationaryObject getLocation() {
        if (this.position instanceof MovingObject) {
            return ((MovingObject)this.position).getLocation();
        }
        if (this.position instanceof StationaryObject) {
            return (StationaryObject)this.position;
        }
        return null;
    }

    public int getLocationID() {
        if (this.position instanceof MovingObject) {
            return ((MovingObject)this.position).getLocationID();
        }
        if (this.position instanceof StationaryObject) {
            return this.position.id;
        }
        return -1;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setStamina(int stamina) {
        this.stamina = stamina;
    }

    public void setHp(int hp) {
        this.hp = hp;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public void setBuriedness(int buriedness) {
        this.buriedness = buriedness;
    }

    public String getCurrentAction() {
        if (this.world.getTime() > this.currentActionLastChange) {
            return "AK_REST";
        }
        return this.currentAction;
    }

    public void setCurrentAction(String action) {
        this.currentActionLastChange = this.world.getTime();
        this.currentAction = action;
    }
}

