/*
 * Decompiled with CFR 0.152.
 */
package firesimulator.world;

import firesimulator.util.Geometry;
import firesimulator.world.Building;
import firesimulator.world.World;
import java.awt.Point;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Wall {
    private static final Log LOG = LogFactory.getLog(Wall.class);
    public static int MAX_SAMPLE_DISTANCE = 50000;
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    public Building owner;
    public int rays;
    public int hits;
    public int selfHits;
    public int strange;
    public static float RAY_RATE = 0.01f;
    public double length;
    Point a;
    Point b;

    public Wall(int x1, int y1, int x2, int y2, Building owner) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.a = new Point(x1, y1);
        this.b = new Point(x2, y2);
        this.length = this.a.distance(this.b);
        this.rays = (int)Math.ceil(this.length * (double)RAY_RATE);
        this.hits = 0;
        this.owner = owner;
    }

    public boolean validate() {
        return this.a.x != this.b.x || this.a.y != this.b.y;
    }

    public void findHits(World world) {
        this.selfHits = 0;
        this.strange = 0;
        for (int emitted = 0; emitted < this.rays; ++emitted) {
            Point start = Geometry.getRndPoint(this.a, this.b);
            if (start == null) {
                ++this.strange;
                LOG.debug((Object)("strange -> " + this.a.x + "," + this.a.y + "/" + this.b.x + "," + this.b.y));
                continue;
            }
            Point end = Geometry.getRndPoint(start, MAX_SAMPLE_DISTANCE);
            Wall closest = null;
            double minDist = Double.MAX_VALUE;
            for (Wall other : world.allWalls) {
                Point cross;
                if (other == this || (cross = Geometry.intersect(start, end, other.a, other.b)) == null || !(cross.distance(start) < minDist)) continue;
                minDist = cross.distance(start);
                closest = other;
            }
            if (closest == null) continue;
            if (closest.owner == this.owner) {
                ++this.selfHits;
            }
            if (closest == this || closest == null || closest.owner == this.owner) continue;
            ++this.hits;
            Integer value = (Integer)this.owner.connectedBuildings.get(closest.owner);
            int temp = 0;
            if (value != null) {
                temp = value;
            }
            this.owner.connectedBuildings.put(closest.owner, new Integer(++temp));
        }
    }

    public String toString() {
        return "wall (" + this.a.x + "," + this.a.y + ")-(" + this.b.x + "," + this.b.y + "), length=" + this.length + "mm, rays=" + this.rays;
    }
}

