/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kernel.CommunicationModel;
import rescuecore2.config.Config;
import rescuecore2.messages.Command;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public abstract class AbstractCommunicationModel
implements CommunicationModel {
    private Map<Entity, Set<Command>> hearing = new LazyMap<Entity, Set<Command>>(){

        public Set<Command> createValue() {
            return new HashSet<Command>();
        }
    };

    @Override
    public void initialise(Config config, WorldModel<? extends Entity> model) {
        this.hearing.clear();
    }

    @Override
    public void process(int time, Collection<? extends Command> agentCommands) {
        this.hearing.clear();
    }

    @Override
    public Collection<Command> getHearing(Entity agent) {
        return this.hearing.get(agent);
    }

    protected void addHearing(Entity agent, Command ... c) {
        this.addHearing(agent, Arrays.asList(c));
    }

    protected void addHearing(Entity agent, Collection<? extends Command> c) {
        this.hearing.get(agent).addAll(c);
    }
}

