/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.Collection;
import java.util.Collections;
import kernel.KernelComponent;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionException;
import rescuecore2.log.Logger;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.Shutdown;

public abstract class AbstractKernelComponent
implements KernelComponent {
    private Connection connection;
    private String name;

    protected AbstractKernelComponent(String name, Connection c) {
        this.name = name;
        this.connection = c;
    }

    @Override
    public void send(Collection<? extends Message> messages) {
        if (!this.connection.isAlive()) {
            return;
        }
        try {
            this.connection.sendMessages(messages);
        }
        catch (ConnectionException e) {
            Logger.error((String)"Error sending message", (Throwable)e);
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void shutdown() {
        this.send((Message)new Shutdown());
        this.connection.shutdown();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void send(Message message) {
        this.send(Collections.singleton(message));
    }
}

