/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import kernel.AgentRegistrar;
import kernel.ChainedCommandFilter;
import kernel.CommandCollector;
import kernel.CommandFilter;
import kernel.CommunicationModel;
import kernel.ComponentManager;
import kernel.CompositeCommandCollector;
import kernel.InlineComponentLauncher;
import kernel.Kernel;
import kernel.KernelException;
import kernel.KernelListener;
import kernel.KernelStartupOptions;
import kernel.OrTerminationCondition;
import kernel.Perception;
import kernel.TerminationCondition;
import kernel.WorldModelCreator;
import kernel.ui.KernelGUI;
import kernel.ui.KernelStartupPanel;
import kernel.ui.ScoreGraph;
import kernel.ui.ScoreTable;
import rescuecore2.GUIComponent;
import rescuecore2.components.ComponentConnectionException;
import rescuecore2.components.ComponentInitialisationException;
import rescuecore2.config.ClassNameSetValueConstraint;
import rescuecore2.config.ClassNameValueConstraint;
import rescuecore2.config.Config;
import rescuecore2.config.ConfigConstraint;
import rescuecore2.config.ConfigException;
import rescuecore2.config.IntegerValueConstraint;
import rescuecore2.connection.ConnectionException;
import rescuecore2.connection.ConnectionManager;
import rescuecore2.connection.ConnectionManagerListener;
import rescuecore2.log.LogException;
import rescuecore2.log.Logger;
import rescuecore2.misc.CommandLineOptions;
import rescuecore2.misc.MutableBoolean;
import rescuecore2.misc.Pair;
import rescuecore2.misc.java.JavaTools;
import rescuecore2.misc.java.LoadableType;
import rescuecore2.misc.java.LoadableTypeProcessor;
import rescuecore2.registry.EntityFactory;
import rescuecore2.registry.MessageFactory;
import rescuecore2.registry.PropertyFactory;
import rescuecore2.registry.Registry;
import rescuecore2.score.ScoreFunction;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public final class StartKernel {
    private static final String NO_STARTUP_MENU = "--nomenu";
    private static final String NO_GUI = "--nogui";
    private static final String AUTORUN = "--autorun";
    private static final String GIS_MANIFEST_KEY = "Gis";
    private static final String PERCEPTION_MANIFEST_KEY = "Perception";
    private static final String COMMUNICATION_MANIFEST_KEY = "CommunicationModel";
    private static final String COMMAND_COLLECTOR_KEY = "kernel.commandcollectors";
    private static final String TERMINATION_KEY = "kernel.termination";
    private static final String GIS_REGEX = "(.+WorldModelCreator).class";
    private static final String PERCEPTION_REGEX = "(.+Perception).class";
    private static final String COMMUNICATION_REGEX = "(.+CommunicationModel).class";
    private static final LoadableType GIS_LOADABLE_TYPE = new LoadableType("Gis", "(.+WorldModelCreator).class", WorldModelCreator.class);
    private static final LoadableType PERCEPTION_LOADABLE_TYPE = new LoadableType("Perception", "(.+Perception).class", Perception.class);
    private static final LoadableType COMMUNICATION_LOADABLE_TYPE = new LoadableType("CommunicationModel", "(.+CommunicationModel).class", CommunicationModel.class);
    private static final String KERNEL_STARTUP_TIME_KEY = "kernel.startup.connect-time";
    private static final String COMMAND_FILTERS_KEY = "kernel.commandfilters";
    private static final String AGENT_REGISTRAR_KEY = "kernel.agents.registrar";
    private static final String GUI_COMPONENTS_KEY = "kernel.ui.components";

    private StartKernel() {
    }

    public static void main(String[] args) {
        Config config = new Config();
        boolean showStartupMenu = true;
        boolean showGUI = true;
        boolean autorun = false;
        Logger.setLogContext((String)"startup");
        try {
            MessageFactory factory;
            args = CommandLineOptions.processArgs((String[])args, (Config)config);
            boolean i = false;
            for (String arg : args) {
                if (arg.equalsIgnoreCase(NO_GUI)) {
                    showGUI = false;
                    continue;
                }
                if (arg.equalsIgnoreCase(NO_STARTUP_MENU)) {
                    showStartupMenu = false;
                    continue;
                }
                if (arg.equalsIgnoreCase(AUTORUN)) {
                    autorun = true;
                    continue;
                }
                Logger.warn((String)("Unrecognised option: " + arg));
            }
            StartKernel.processJarFiles(config);
            Registry localRegistry = new Registry("Kernel local registry");
            for (String next : config.getArrayValue("factory.messages", "")) {
                factory = (MessageFactory)JavaTools.instantiateFactory((String)next, MessageFactory.class);
                if (factory == null) continue;
                localRegistry.registerMessageFactory(factory);
                Logger.info((String)("Registered local message factory: " + next));
            }
            for (String next : config.getArrayValue("factory.entities", "")) {
                factory = (EntityFactory)JavaTools.instantiateFactory((String)next, EntityFactory.class);
                if (factory == null) continue;
                localRegistry.registerEntityFactory((EntityFactory)factory);
                Logger.info((String)("Registered local entity factory: " + next));
            }
            for (String next : config.getArrayValue("factory.properties", "")) {
                factory = (PropertyFactory)JavaTools.instantiateFactory((String)next, PropertyFactory.class);
                if (factory == null) continue;
                localRegistry.registerPropertyFactory((PropertyFactory)factory);
                Logger.info((String)("Registered local property factory: " + next));
            }
            config.addConstraint((ConfigConstraint)new IntegerValueConstraint("kernel.port", 1, 65535));
            config.addConstraint((ConfigConstraint)new IntegerValueConstraint(KERNEL_STARTUP_TIME_KEY, 0, Integer.MAX_VALUE));
            config.addConstraint((ConfigConstraint)new ClassNameSetValueConstraint("factory.messages", MessageFactory.class));
            config.addConstraint((ConfigConstraint)new ClassNameSetValueConstraint("factory.entities", EntityFactory.class));
            config.addConstraint((ConfigConstraint)new ClassNameSetValueConstraint("factory.properties", PropertyFactory.class));
            config.addConstraint((ConfigConstraint)new ClassNameSetValueConstraint(COMMAND_FILTERS_KEY, CommandFilter.class));
            config.addConstraint((ConfigConstraint)new ClassNameSetValueConstraint(TERMINATION_KEY, TerminationCondition.class));
            config.addConstraint((ConfigConstraint)new ClassNameSetValueConstraint(COMMAND_COLLECTOR_KEY, CommandCollector.class));
            config.addConstraint((ConfigConstraint)new ClassNameSetValueConstraint(GUI_COMPONENTS_KEY, GUIComponent.class));
            config.addConstraint((ConfigConstraint)new ClassNameValueConstraint(AGENT_REGISTRAR_KEY, AgentRegistrar.class));
            config.addConstraint((ConfigConstraint)new ClassNameValueConstraint("score.function", ScoreFunction.class));
            Logger.setLogContext((String)"kernel");
            final KernelInfo kernelInfo = StartKernel.createKernel(config, showStartupMenu);
            if (kernelInfo == null) {
                System.exit(0);
            }
            KernelGUI gui = null;
            if (showGUI) {
                gui = new KernelGUI(kernelInfo.kernel, kernelInfo.componentManager, config, localRegistry, !autorun);
                for (GUIComponent next : kernelInfo.guiComponents) {
                    gui.addGUIComponent(next);
                    if (!(next instanceof KernelListener)) continue;
                    kernelInfo.kernel.addKernelListener((KernelListener)next);
                }
                JFrame frame = new JFrame("Kernel GUI");
                frame.getContentPane().add(gui);
                frame.pack();
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        kernelInfo.kernel.shutdown();
                        System.exit(0);
                    }
                });
                frame.setVisible(true);
            }
            StartKernel.initialiseKernel(kernelInfo, config, localRegistry);
            StartKernel.autostartComponents(kernelInfo, localRegistry, gui, config);
            if (!showGUI || autorun) {
                StartKernel.waitForComponentManager(kernelInfo, config);
                Kernel kernel = kernelInfo.kernel;
                while (!kernel.hasTerminated()) {
                    kernel.timestep();
                }
                kernel.shutdown();
            }
        }
        catch (ConfigException e) {
            Logger.fatal((String)"Couldn't start kernel", (Throwable)e);
        }
        catch (KernelException e) {
            Logger.fatal((String)"Couldn't start kernel", (Throwable)e);
        }
        catch (IOException e) {
            Logger.fatal((String)"Couldn't start kernel", (Throwable)e);
        }
        catch (LogException e) {
            Logger.fatal((String)"Couldn't write log", (Throwable)e);
        }
        catch (InterruptedException e) {
            Logger.fatal((String)"Kernel interrupted");
        }
    }

    private static KernelInfo createKernel(Config config, boolean showMenu) throws KernelException {
        KernelStartupOptions options = new KernelStartupOptions(config);
        if (showMenu) {
            final JDialog dialog = new JDialog((Frame)null, "Setup kernel options", true);
            KernelStartupPanel panel = new KernelStartupPanel(config, options);
            JButton okButton = new JButton("OK");
            JButton cancelButton = new JButton("Cancel");
            JPanel buttons = new JPanel(new FlowLayout());
            buttons.add(okButton);
            buttons.add(cancelButton);
            dialog.getContentPane().add((Component)panel, "Center");
            dialog.getContentPane().add((Component)buttons, "South");
            final MutableBoolean ok = new MutableBoolean(true);
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ok.set(true);
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ok.set(false);
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            dialog.pack();
            dialog.setVisible(true);
            if (!ok.get()) {
                return null;
            }
        }
        WorldModelCreator gis = options.getWorldModelCreator();
        Perception perception = options.getPerception();
        CommunicationModel comms = options.getCommunicationModel();
        CommandFilter filter = StartKernel.makeCommandFilter(config);
        TerminationCondition termination = StartKernel.makeTerminationCondition(config);
        ScoreFunction score = StartKernel.makeScoreFunction(config);
        CommandCollector collector = StartKernel.makeCommandCollector(config);
        WorldModel<? extends Entity> worldModel = gis.buildWorldModel(config);
        ScoreGraph graph = new ScoreGraph(score);
        Kernel kernel = new Kernel(config, perception, comms, worldModel, gis, filter, termination, (ScoreFunction)graph, collector);
        ComponentManager componentManager = new ComponentManager(kernel, worldModel, config);
        KernelInfo result = new KernelInfo(kernel, options, componentManager, StartKernel.makeGUIComponents(config, new Object[]{componentManager, perception, comms, termination, filter, graph, collector, score}));
        return result;
    }

    private static void initialiseKernel(KernelInfo kernel, Config config, Registry registry) throws KernelException {
        StartKernel.registerInitialAgents(config, kernel.componentManager, kernel.kernel.getWorldModel());
        if (!config.getBooleanValue("kernel.inline-only", false)) {
            ConnectionManager connectionManager = new ConnectionManager();
            try {
                connectionManager.listen(config.getIntValue("kernel.port"), registry, (ConnectionManagerListener)kernel.componentManager);
            }
            catch (IOException e) {
                throw new KernelException("Couldn't open kernel port", e);
            }
        }
    }

    private static void waitForComponentManager(final KernelInfo kernel, Config config) throws KernelException {
        final CountDownLatch latch = new CountDownLatch(1);
        final long timeout = config.getIntValue(KERNEL_STARTUP_TIME_KEY, -1);
        Thread timeoutThread = null;
        if (timeout > 0L) {
            timeoutThread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(timeout);
                        latch.countDown();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
        }
        Thread waitThread = new Thread(){

            @Override
            public void run() {
                try {
                    kernel.componentManager.waitForAllAgents();
                    kernel.componentManager.waitForAllSimulators();
                    kernel.componentManager.waitForAllViewers();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                latch.countDown();
            }
        };
        waitThread.start();
        if (timeoutThread != null) {
            timeoutThread.start();
        }
        Logger.info((String)"Waiting for all agents, simulators and viewers to connect.");
        if (timeout > -1L) {
            Logger.info((String)("Connection timeout is " + timeout + "ms"));
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            waitThread.interrupt();
            if (timeoutThread != null) {
                timeoutThread.interrupt();
            }
            throw new KernelException("Interrupted");
        }
    }

    private static void autostartComponents(KernelInfo info, Registry registry, KernelGUI gui, Config config) throws InterruptedException {
        KernelStartupOptions options = info.options;
        ArrayList<ComponentStarter> all = new ArrayList<ComponentStarter>();
        Config launchConfig = new Config(config);
        launchConfig.removeExcept(new String[]{"random.seed", "random.class"});
        for (Pair<String, Integer> next : options.getInlineComponents()) {
            if ((Integer)next.second() <= 0) continue;
            all.add(new ComponentStarter((String)next.first(), info.componentManager, (Integer)next.second(), registry, gui, launchConfig));
        }
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        service.invokeAll(all);
    }

    private static void registerInitialAgents(Config config, ComponentManager c, WorldModel<? extends Entity> model) throws KernelException {
        AgentRegistrar ar = (AgentRegistrar)JavaTools.instantiate((String)config.getValue(AGENT_REGISTRAR_KEY), AgentRegistrar.class);
        if (ar == null) {
            throw new KernelException("Couldn't instantiate agent registrar");
        }
        ar.registerAgents(model, config, c);
    }

    private static CommandFilter makeCommandFilter(Config config) {
        ChainedCommandFilter result = new ChainedCommandFilter();
        List classNames = config.getArrayValue(COMMAND_FILTERS_KEY, null);
        for (String next : classNames) {
            Logger.debug((String)("Command filter found: '" + next + "'"));
            CommandFilter f = (CommandFilter)JavaTools.instantiate((String)next, CommandFilter.class);
            if (f == null) continue;
            result.addFilter(f);
        }
        return result;
    }

    private static TerminationCondition makeTerminationCondition(Config config) {
        ArrayList<TerminationCondition> result = new ArrayList<TerminationCondition>();
        for (String next : config.getArrayValue(TERMINATION_KEY, null)) {
            TerminationCondition t = (TerminationCondition)JavaTools.instantiate((String)next, TerminationCondition.class);
            if (t == null) continue;
            result.add(t);
        }
        return new OrTerminationCondition(result);
    }

    private static ScoreFunction makeScoreFunction(Config config) {
        String className = config.getValue("score.function");
        ScoreFunction result = (ScoreFunction)JavaTools.instantiate((String)className, ScoreFunction.class);
        return new ScoreTable(result);
    }

    private static CommandCollector makeCommandCollector(Config config) {
        List classNames = config.getArrayValue(COMMAND_COLLECTOR_KEY);
        CompositeCommandCollector result = new CompositeCommandCollector();
        for (String next : classNames) {
            CommandCollector c = (CommandCollector)JavaTools.instantiate((String)next, CommandCollector.class);
            if (c == null) continue;
            result.addCommandCollector(c);
        }
        return result;
    }

    private static List<GUIComponent> makeGUIComponents(Config config, Object ... objectsToTest) {
        ArrayList<GUIComponent> result = new ArrayList<GUIComponent>();
        List classNames = config.getArrayValue(GUI_COMPONENTS_KEY, null);
        for (String next : classNames) {
            Logger.debug((String)("GUI component found: '" + next + "'"));
            GUIComponent c = (GUIComponent)JavaTools.instantiate((String)next, GUIComponent.class);
            if (c == null) continue;
            result.add(c);
        }
        for (Object next : objectsToTest) {
            if (!(next instanceof GUIComponent)) continue;
            result.add((GUIComponent)next);
        }
        return result;
    }

    private static void processJarFiles(Config config) throws IOException {
        LoadableTypeProcessor processor = new LoadableTypeProcessor(config);
        processor.addFactoryRegisterCallbacks(Registry.SYSTEM_REGISTRY);
        processor.addConfigUpdater(LoadableType.AGENT, config, "kernel.agents");
        processor.addConfigUpdater(LoadableType.SIMULATOR, config, "kernel.simulators");
        processor.addConfigUpdater(LoadableType.VIEWER, config, "kernel.viewers");
        processor.addConfigUpdater(LoadableType.COMPONENT, config, "kernel.components");
        processor.addConfigUpdater(GIS_LOADABLE_TYPE, config, "kernel.gis");
        processor.addConfigUpdater(PERCEPTION_LOADABLE_TYPE, config, "kernel.perception");
        processor.addConfigUpdater(COMMUNICATION_LOADABLE_TYPE, config, "kernel.communication");
        Logger.info((String)"Looking for gis, perception, communication, agent, simulator and viewer implementations");
        processor.process();
    }

    private static class KernelInfo {
        Kernel kernel;
        KernelStartupOptions options;
        ComponentManager componentManager;
        List<GUIComponent> guiComponents;

        public KernelInfo(Kernel kernel, KernelStartupOptions options, ComponentManager componentManager, List<GUIComponent> otherComponents) {
            this.kernel = kernel;
            this.options = options;
            this.componentManager = componentManager;
            this.guiComponents = new ArrayList<GUIComponent>(otherComponents);
        }
    }

    private static class ComponentStarter
    implements Callable<Void> {
        private String className;
        private ComponentManager componentManager;
        private int count;
        private Registry registry;
        private KernelGUI gui;
        private Config config;

        public ComponentStarter(String className, ComponentManager componentManager, int count, Registry registry, KernelGUI gui, Config config) {
            this.className = className;
            this.componentManager = componentManager;
            this.count = count;
            this.registry = registry;
            this.gui = gui;
            this.config = config;
            Logger.debug((String)("New ComponentStarter: " + className + " * " + count));
        }

        @Override
        public Void call() throws InterruptedException {
            rescuecore2.components.Component c;
            Logger.debug((String)("ComponentStarter running: " + this.className + " * " + this.count));
            InlineComponentLauncher launcher = new InlineComponentLauncher(this.componentManager, this.config);
            launcher.setDefaultRegistry(this.registry);
            Logger.info((String)("Launching " + this.count + " instances of component '" + this.className + "'..."));
            for (int i = 0; i < this.count && (c = (rescuecore2.components.Component)JavaTools.instantiate((String)this.className, rescuecore2.components.Component.class)) != null; ++i) {
                Logger.info((String)("Launching " + this.className + " instance " + (i + 1) + "..."));
                try {
                    c.initialise();
                    launcher.connect(c);
                    if (this.gui != null && c instanceof GUIComponent) {
                        this.gui.addGUIComponent((GUIComponent)c);
                    }
                    Logger.info((String)(this.className + "instance " + (i + 1) + " launched successfully"));
                    continue;
                }
                catch (ComponentConnectionException e) {
                    Logger.info((String)(this.className + "instance " + (i + 1) + " failed: " + e.getMessage()));
                    break;
                }
                catch (ComponentInitialisationException e) {
                    Logger.info((String)(this.className + "instance " + (i + 1) + " failed"), (Throwable)e);
                    continue;
                }
                catch (ConnectionException e) {
                    Logger.info((String)(this.className + "instance " + (i + 1) + " failed"), (Throwable)e);
                }
            }
            return null;
        }
    }
}

