/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TDoubleHashSet;
import gnu.trove.TDoubleIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class TDoubleHashSetDecorator
extends AbstractSet
implements Set {
    protected final TDoubleHashSet _set;

    public boolean add(Object value) {
        return this._set.add(this.unwrap(value));
    }

    public boolean equals(Object other) {
        if (this._set.equals(other)) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (that.size() != this._set.size()) {
                return false;
            }
            Iterator it = that.iterator();
            int i = that.size();
            while (i-- > 0) {
                Object val = it.next();
                if (val instanceof Double) {
                    double v = this.unwrap(val);
                    if (this._set.contains(v)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this._set.clear();
    }

    public boolean remove(Object value) {
        return this._set.remove(this.unwrap(value));
    }

    public Iterator iterator() {
        return new Iterator(this){
            private final TDoubleIterator it;
            private final /* synthetic */ TDoubleHashSetDecorator this$0;

            public final Object next() {
                return this.this$0.wrap(this.it.next());
            }

            public final boolean hasNext() {
                return this.it.hasNext();
            }

            public final void remove() {
                this.it.remove();
            }
            {
                this.this$0 = this$0;
                this.it = this.this$0._set.iterator();
                this.constructor$0(this$0);
            }

            private final void constructor$0(TDoubleHashSetDecorator tDoubleHashSetDecorator) {
            }
        };
    }

    public int size() {
        return this._set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Double wrap(double k) {
        return new Double(k);
    }

    protected double unwrap(Object value) {
        return (Double)value;
    }

    public TDoubleHashSetDecorator(TDoubleHashSet set) {
        this._set = set;
    }
}

