/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.objects;

import rescuecore.IntProperty;
import rescuecore.Property;
import rescuecore.objects.VirtualObject;

public class World
extends VirtualObject {
    private IntProperty startTime;
    private IntProperty longitude;
    private IntProperty latitude;
    private IntProperty windForce;
    private IntProperty windDirection;

    public World() {
        this.startTime = new IntProperty(1);
        this.longitude = new IntProperty(2);
        this.latitude = new IntProperty(3);
        this.windForce = new IntProperty(4);
        this.windDirection = new IntProperty(5);
    }

    public World(int start, int lon, int lat, int force, int direction) {
        this.startTime = new IntProperty(1, start);
        this.longitude = new IntProperty(2, lon);
        this.latitude = new IntProperty(3, lat);
        this.windForce = new IntProperty(4, force);
        this.windDirection = new IntProperty(5, direction);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Property getProperty(int property) {
        switch (property) {
            case 1: {
                return this.startTime;
            }
            case 2: {
                return this.longitude;
            }
            case 3: {
                return this.latitude;
            }
            case 4: {
                return this.windForce;
            }
            case 5: {
                return this.windDirection;
            }
        }
        return super.getProperty(property);
    }

    public int getStartTime() {
        return this.startTime.getValue();
    }

    public boolean setStartTime(int s, int timestamp, Object source) {
        if (this.startTime.updateValue(s, timestamp, source)) {
            this.firePropertyChanged(1, timestamp, source);
            return true;
        }
        return false;
    }

    public int getLongitude() {
        return this.longitude.getValue();
    }

    public boolean setLongitude(int l, int timestamp, Object source) {
        if (this.longitude.updateValue(l, timestamp, source)) {
            this.firePropertyChanged(2, timestamp, source);
            return true;
        }
        return false;
    }

    public int getLatitude() {
        return this.latitude.getValue();
    }

    public boolean setLatitude(int l, int timestamp, Object source) {
        if (this.latitude.updateValue(l, timestamp, source)) {
            this.firePropertyChanged(3, timestamp, source);
            return true;
        }
        return false;
    }

    public int getWindForce() {
        return this.windForce.getValue();
    }

    public boolean setWindForce(int w, int timestamp, Object source) {
        if (this.windForce.updateValue(w, timestamp, source)) {
            this.firePropertyChanged(4, timestamp, source);
            return true;
        }
        return false;
    }

    public int getWindDirection() {
        return this.windDirection.getValue();
    }

    public boolean setWindDirection(int w, int timestamp, Object source) {
        if (this.windDirection.updateValue(w, timestamp, source)) {
            this.firePropertyChanged(5, timestamp, source);
            return true;
        }
        return false;
    }
}

