/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.mapgenerator;

import java.util.ArrayList;
import java.util.Random;
import rescuecore.tools.mapgenerator.BlocksBuildingGenerator;
import rescuecore.tools.mapgenerator.RescueMap;
import rescuecore.tools.mapgenerator.RescueMapToolkit;

public class BasicBuildingGenerator
extends BlocksBuildingGenerator {
    @Override
    protected int[][][] fillBlock(RescueMap rm, int[] block, int density, Random rand) {
        int[][] build = new int[block.length + 1][2];
        for (int i = 0; i < block.length; ++i) {
            build[i][0] = rm.getX(block[i]);
            build[i][1] = rm.getY(block[i]);
            if (i <= 0 || i >= block.length - 1) continue;
            BasicBuildingGenerator.shift(rm, block[i - 1], block[i], block[i + 1], build[i]);
        }
        BasicBuildingGenerator.shift(rm, block[block.length - 1], block[0], block[1], build[0]);
        BasicBuildingGenerator.shift(rm, block[block.length - 2], block[block.length - 1], block[0], build[build.length - 2]);
        build[build.length - 1][0] = build[0][0];
        build[build.length - 1][1] = build[0][1];
        int minArea = 500000 / (density + 1);
        ArrayList builds = this.processBuilding(build, minArea, rand);
        int[][][] bs = new int[builds.size()][][];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (int[][])builds.get(i);
            this.shrink(bs[i], rand.nextDouble() * 0.4);
        }
        return bs;
    }

    private void shrink(int[][] building, double amount) {
        int xMin = building[0][0];
        int xMax = building[0][0];
        int yMin = building[0][1];
        int yMax = building[0][1];
        for (int i = 1; i < building.length; ++i) {
            xMin = Math.min(xMin, building[i][0]);
            xMax = Math.max(xMax, building[i][0]);
            yMin = Math.min(yMin, building[i][1]);
            yMax = Math.max(yMax, building[i][1]);
        }
        int xCenter = (xMin + xMax) / 2;
        int yCenter = (yMin + yMax) / 2;
        for (int i = 0; i < building.length; ++i) {
            double dx = building[i][0] - xCenter;
            double dy = building[i][1] - yCenter;
            int[] nArray = building[i];
            nArray[0] = nArray[0] - (int)(dx * amount);
            int[] nArray2 = building[i];
            nArray2[1] = nArray2[1] - (int)(dy * amount);
        }
    }

    @Override
    protected int[][][] fillOuterBlock(RescueMap rm, int[] block, int density, Random rand) {
        return new int[0][][];
    }

    private static void shift(RescueMap rm, int n1, int n2, int n3, int[] c) {
        int y4;
        long n1y = rm.getX(n2) - rm.getX(n1);
        long n1x = rm.getY(n1) - rm.getY(n2);
        long n2y = rm.getX(n3) - rm.getX(n2);
        long n2x = rm.getY(n2) - rm.getY(n3);
        double len1 = Math.sqrt(n1y * n1y + n1x * n1x);
        double len2 = Math.sqrt(n2y * n2y + n2x * n2x);
        int d = 3000;
        int x1 = rm.getX(n1) - (int)((double)(n1x * (long)d) * 1.0 / len1);
        int x2 = rm.getX(n2) - (int)((double)(n1x * (long)d) * 1.0 / len1);
        int y1 = rm.getY(n1) - (int)((double)(n1y * (long)d) * 1.0 / len1);
        int y2 = rm.getY(n2) - (int)((double)(n1y * (long)d) * 1.0 / len1);
        int x3 = rm.getX(n2) - (int)((double)(n2x * (long)d) * 1.0 / len2);
        int x4 = rm.getX(n3) - (int)((double)(n2x * (long)d) * 1.0 / len2);
        int y3 = rm.getY(n2) - (int)((double)(n2y * (long)d) * 1.0 / len2);
        int[] intersect = BasicBuildingGenerator.intersection(x1, y1, x2, y2, x3, y3, x4, y4 = rm.getY(n3) - (int)((double)(n2y * (long)d) * 1.0 / len2));
        if (intersect == null) {
            c[0] = (int)((double)c[0] - (double)n1x / len1 * (double)d);
            c[1] = (int)((double)c[1] - (double)n1y / len1 * (double)d);
        } else {
            c[0] = intersect[0];
            c[1] = intersect[1];
        }
    }

    private static int[] intersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double b1 = (y2 - y1) / (x2 - x1);
        double a1 = y1 - b1 * x1;
        double b2 = (y4 - y3) / (x4 - x3);
        double a2 = y3 - b2 * x3;
        if (x2 - x1 == 0.0) {
            return new int[]{(int)x1, (int)(a2 + b2 * x1)};
        }
        if (x3 - x4 == 0.0) {
            return new int[]{(int)x3, (int)(a1 + b1 * x3)};
        }
        double d = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (d == 0.0) {
            return null;
        }
        double a = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) * 1.0 / d;
        int intX = (int)x1 + (int)(a * (x2 - x1));
        int intY = (int)y1 + (int)(a * (y2 - y1));
        return new int[]{intX, intY};
    }

    private ArrayList processBuilding(int[][] building, int minArea, Random rand) {
        int i;
        int a = RescueMapToolkit.area(building);
        if (a < 1000) {
            return new ArrayList(0);
        }
        if (a < minArea) {
            ArrayList<int[][]> l = new ArrayList<int[][]>(1);
            l.add(building);
            return l;
        }
        int lower = (int)(rand.nextDouble() * (double)minArea);
        if (a < (lower *= 4)) {
            ArrayList<int[][]> l = new ArrayList<int[][]>(1);
            l.add(building);
            return l;
        }
        int minX = building[0][0];
        int minY = building[0][1];
        int maxX = building[0][0];
        int maxY = building[0][1];
        for (int i2 = 1; i2 < building.length; ++i2) {
            if (minX > building[i2][0]) {
                minX = building[i2][0];
            }
            if (maxX < building[i2][0]) {
                maxX = building[i2][0];
            }
            if (minY > building[i2][1]) {
                minY = building[i2][1];
            }
            if (maxY >= building[i2][1]) continue;
            maxY = building[i2][1];
        }
        int midX = (minX + maxX) / 2;
        int midY = (minY + maxY) / 2;
        int[][][] split = maxX - minX > maxY - minY ? RescueMapToolkit.split(building, midX, minY, midX, maxY) : RescueMapToolkit.split(building, minX, midY, maxX, midY);
        if (split == null || RescueMapToolkit.area(split[0]) == 0 || RescueMapToolkit.area(split[1]) == 0) {
            return new ArrayList(0);
        }
        ArrayList a1 = this.processBuilding(split[0], minArea, rand);
        ArrayList a2 = this.processBuilding(split[1], minArea, rand);
        ArrayList toRet = new ArrayList(a1.size() + a2.size());
        for (i = 0; i < a1.size(); ++i) {
            toRet.add(a1.get(i));
        }
        for (i = 0; i < a2.size(); ++i) {
            toRet.add(a2.get(i));
        }
        return toRet;
    }
}

