/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.simulationrunner;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import rescuecore.tools.simulationrunner.RescueProcess;

public class LogReader
implements Runnable {
    private boolean running;
    private boolean alive;
    private InputStream in;
    private List out;
    private final Object waitLock = new Object();
    private String waitingFor;
    private StringBuffer waitBuffer;

    public LogReader(InputStream in, OutputStream log) {
        this.in = in;
        this.out = new ArrayList();
        if (log != null) {
            this.out.add(log);
        }
    }

    public LogReader(InputStream in) {
        this.in = in;
        this.out = new ArrayList();
    }

    public void addOutputStream(OutputStream stream) {
        this.out.add(stream);
    }

    public synchronized void kill() {
        this.running = false;
        while (this.alive) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void start() {
        this.start(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String waitFor, RescueProcess process) {
        Object object = this.waitLock;
        synchronized (object) {
            new Thread(this).start();
            this.waitingFor = waitFor;
            if (waitFor == null || waitFor.equals("")) {
                return;
            }
            this.waitBuffer = new StringBuffer();
            while (this.waitingFor != null && process.isRunning()) {
                try {
                    this.waitLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        this.alive = true;
        byte[] data = new byte[1024];
        try {
            while (this.running) {
                Thread.yield();
                int available = Math.min(data.length, this.in.available());
                if (available == 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                int count = this.in.read(data, 0, available);
                if (count <= 0) continue;
                this.checkWait(data);
                for (OutputStream next : this.out) {
                    next.write(data, 0, count);
                    next.flush();
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        for (OutputStream next : this.out) {
            try {
                next.flush();
                next.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LogReader logReader = this;
        synchronized (logReader) {
            this.alive = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWait(byte[] data) {
        Object object = this.waitLock;
        synchronized (object) {
            if (this.waitingFor == null || this.waitBuffer == null) {
                return;
            }
            this.waitBuffer.append(new String(data));
            String s = this.waitBuffer.toString();
            if (s.indexOf(this.waitingFor) != -1) {
                this.waitingFor = null;
                this.waitBuffer = null;
                this.waitLock.notifyAll();
            }
        }
    }
}

