/*
 * Decompiled with CFR 0.152.
 */
package human;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.misc.Handy;
import rescuecore2.standard.components.StandardAgent;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.Refuge;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.EntityID;
import sample.SampleSearch;

public class ControlledAmbulanceTeam
extends StandardAgent<AmbulanceTeam> {
    private SampleSearch search;
    private Human target;

    public void setTarget(Human target) {
        this.target = target;
    }

    protected void think(int time, ChangeSet changed, Collection<Command> heard) {
        if (this.target == null) {
            Logger.info((String)"Nothing to do.");
            return;
        }
        if (this.target.getPosition().equals((Object)this.getID())) {
            if (this.location() instanceof Refuge) {
                this.sendUnload(time);
                return;
            }
            List path = this.search.breadthFirstSearch(((AmbulanceTeam)this.me()).getPosition(), (Collection)Handy.objectsToIDs((Collection)((StandardWorldModel)this.model).getEntitiesOfType(StandardEntityURN.REFUGE)));
            if (path != null) {
                this.sendMove(time, path);
                return;
            }
            Logger.info((String)"Couldn't plan a path to refuge.");
            return;
        }
        if (this.target.getPosition().equals((Object)((AmbulanceTeam)this.me()).getPosition())) {
            if (this.target.getBuriedness() != 0) {
                this.sendRescue(time, this.target.getID());
                return;
            }
            this.sendLoad(time, this.target.getID());
            return;
        }
        List path = this.search.breadthFirstSearch(((AmbulanceTeam)this.me()).getPosition(), new EntityID[]{this.target.getID()});
        if (path != null) {
            this.sendMove(time, path);
            return;
        }
        Logger.info((String)"Couldn't plan a path to target.");
    }

    protected EnumSet<StandardEntityURN> getRequestedEntityURNsEnum() {
        return EnumSet.of(StandardEntityURN.AMBULANCE_TEAM);
    }

    protected StandardEntity location() {
        AmbulanceTeam me = (AmbulanceTeam)this.me();
        return me.getPosition(this.model);
    }

    protected void postConnect() {
        super.postConnect();
        this.search = new SampleSearch((StandardWorldModel)this.model);
    }

    public String toString() {
        if (this.me() == null) {
            return "Human controlled ambulance team";
        }
        StringBuilder result = new StringBuilder();
        result.append("Human controlled ambulance team ");
        result.append(this.getID());
        result.append(" ");
        if (this.target == null) {
            result.append("(no target)");
        } else {
            result.append("target: human ");
            result.append(this.target.getID());
            if (this.target.getPosition().equals((Object)this.getID())) {
                result.append(" (loaded)");
            }
        }
        return result.toString();
    }
}

