/*
 * Decompiled with CFR 0.152.
 */
package maps;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import maps.Map;
import maps.MapException;
import maps.MapFormat;
import maps.gml.formats.GeospatialInformationAuthorityFormat;
import maps.gml.formats.MeijoFormat;
import maps.gml.formats.OrdnanceSurveyFormat;
import maps.gml.formats.RobocupFormat;
import rescuecore2.log.Logger;

public final class MapReader {
    private static final List<MapFormat> ALL_FORMATS = new ArrayList<MapFormat>();

    private MapReader() {
    }

    public static Map readMap(String file) throws MapException {
        return MapReader.readMap(file, null);
    }

    public static Map readMap(String file, MapFormat format) throws MapException {
        return MapReader.readMap(new File(file), format);
    }

    public static Map readMap(File file) throws MapException {
        return MapReader.readMap(file, null);
    }

    public static Map readMap(File file, MapFormat format) throws MapException {
        if (format == null) {
            format = MapReader.guessFormat(file);
        }
        if (format == null) {
            throw new MapException("Unrecognised format");
        }
        Logger.debug((String)("Reading " + format.toString() + " format"));
        return format.read(file);
    }

    public static MapFormat guessFormat(File file) throws MapException {
        Logger.debug((String)"Guessing format");
        for (MapFormat next : ALL_FORMATS) {
            if (!next.canRead(file)) continue;
            return next;
        }
        return null;
    }

    static {
        ALL_FORMATS.add(RobocupFormat.INSTANCE);
        ALL_FORMATS.add(MeijoFormat.INSTANCE);
        ALL_FORMATS.add(OrdnanceSurveyFormat.INSTANCE);
        ALL_FORMATS.add(GeospatialInformationAuthorityFormat.INSTANCE);
    }
}

