/*
 * Decompiled with CFR 0.152.
 */
package maps.convert;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import rescuecore2.log.Logger;
import rescuecore2.misc.gui.ShapeDebugFrame;

public abstract class ConvertStep {
    protected ShapeDebugFrame debug;
    private JProgressBar progress = new JProgressBar();
    private JLabel status = new JLabel();

    protected ConvertStep() {
        this.progress.setString("");
        this.progress.setStringPainted(true);
        this.debug = new ShapeDebugFrame();
    }

    protected void setProgress(final int amount) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertStep.this.progress.setValue(amount);
                ConvertStep.this.progress.setString(ConvertStep.this.progress.getValue() + " / " + ConvertStep.this.progress.getMaximum());
            }
        });
    }

    protected void bumpProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertStep.this.progress.setValue(ConvertStep.this.progress.getValue() + 1);
                ConvertStep.this.progress.setString(ConvertStep.this.progress.getValue() + " / " + ConvertStep.this.progress.getMaximum());
            }
        });
    }

    protected void bumpMaxProgress() {
        this.bumpMaxProgress(1);
    }

    protected void bumpMaxProgress(final int amount) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertStep.this.progress.setMaximum(ConvertStep.this.progress.getMaximum() + amount);
                ConvertStep.this.progress.setString(ConvertStep.this.progress.getValue() + " / " + ConvertStep.this.progress.getMaximum());
            }
        });
    }

    protected void setProgressLimit(final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertStep.this.progress.setIndeterminate(false);
                ConvertStep.this.progress.setMaximum(max);
                ConvertStep.this.progress.setString(ConvertStep.this.progress.getValue() + " / " + ConvertStep.this.progress.getMaximum());
            }
        });
    }

    protected void setStatus(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertStep.this.status.setText(s);
            }
        });
    }

    public JProgressBar getProgressBar() {
        return this.progress;
    }

    public JComponent getStatusComponent() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doStep() {
        try {
            Logger.pushLogContext((String)this.getClass().getName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConvertStep.this.progress.setIndeterminate(true);
                }
            });
            this.step();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConvertStep.this.progress.setIndeterminate(false);
                    ConvertStep.this.progress.setValue(ConvertStep.this.progress.getMaximum());
                }
            });
            this.debug.deactivate();
        }
        finally {
            Logger.popLogContext();
        }
    }

    public abstract String getDescription();

    protected abstract void step();
}

