/*
 * Decompiled with CFR 0.152.
 */
package maps.gml;

import java.util.ArrayList;
import java.util.List;
import maps.gml.GMLCoordinates;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;

public class GMLDirectedEdge {
    private GMLEdge edge;
    private boolean forward;

    public GMLDirectedEdge(GMLEdge edge, boolean forward) {
        this.edge = edge;
        this.forward = forward;
    }

    public GMLDirectedEdge(GMLEdge edge, GMLNode start) {
        this.edge = edge;
        this.forward = start.equals(edge.getStart());
    }

    public GMLEdge getEdge() {
        return this.edge;
    }

    public boolean isForward() {
        return this.forward;
    }

    public void reverse() {
        this.forward = !this.forward;
    }

    public GMLNode getStartNode() {
        return this.forward ? this.edge.getStart() : this.edge.getEnd();
    }

    public GMLNode getEndNode() {
        return this.forward ? this.edge.getEnd() : this.edge.getStart();
    }

    public List<GMLCoordinates> getPoints() {
        ArrayList<GMLCoordinates> result = new ArrayList<GMLCoordinates>();
        result.add(this.getStartNode().getCoordinates());
        result.add(this.getEndNode().getCoordinates());
        return result;
    }

    public GMLCoordinates getStartCoordinates() {
        if (this.forward) {
            return this.edge.getStart().getCoordinates();
        }
        return this.edge.getEnd().getCoordinates();
    }

    public GMLCoordinates getEndCoordinates() {
        if (this.forward) {
            return this.edge.getEnd().getCoordinates();
        }
        return this.edge.getStart().getCoordinates();
    }

    public String toString() {
        return "GMLDirectedEdge" + (this.forward ? "" : " backwards") + " along " + this.edge;
    }

    public int hashCode() {
        return this.edge.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof GMLDirectedEdge) {
            GMLDirectedEdge e = (GMLDirectedEdge)o;
            return this.forward == e.forward && this.edge.equals(e.edge);
        }
        return false;
    }
}

