/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.debug;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import maps.gml.GMLCoordinates;
import maps.gml.GMLShape;
import maps.gml.GMLTools;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.misc.gui.ShapeDebugFrame;

public class GMLShapeInfo
extends ShapeDebugFrame.ShapeInfo {
    private GMLShape shape;
    private Color outlineColour;
    private Color fillColour;
    private Rectangle2D bounds;

    public GMLShapeInfo(GMLShape shape, String name, Color outlineColour, Color fillColour) {
        super((Object)shape, name);
        this.shape = shape;
        this.outlineColour = outlineColour;
        this.fillColour = fillColour;
        if (shape != null) {
            this.bounds = GMLTools.getBounds(shape.getCoordinates());
        }
    }

    public Shape paint(Graphics2D g, ScreenTransform transform) {
        if (this.shape == null) {
            return null;
        }
        List<GMLCoordinates> coordinates = this.shape.getCoordinates();
        int n = coordinates.size();
        int[] xs = new int[n];
        int[] ys = new int[n];
        int i = 0;
        for (GMLCoordinates next : coordinates) {
            xs[i] = transform.xToScreen(next.getX());
            ys[i] = transform.yToScreen(next.getY());
            ++i;
        }
        Polygon p = new Polygon(xs, ys, n);
        if (this.outlineColour != null) {
            g.setColor(this.outlineColour);
            g.draw(p);
        }
        if (this.fillColour != null) {
            g.setColor(this.fillColour);
            g.fill(p);
        }
        return p;
    }

    public void paintLegend(Graphics2D g, int width, int height) {
        if (this.outlineColour != null) {
            g.setColor(this.outlineColour);
            g.drawRect(0, 0, width - 1, height - 1);
        }
        if (this.fillColour != null) {
            g.setColor(this.fillColour);
            g.fillRect(0, 0, width, height);
        }
    }

    public Rectangle2D getBoundsShape() {
        return this.bounds;
    }

    public Point2D getBoundsPoint() {
        return null;
    }
}

