/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLCoordinates;
import maps.gml.GMLEdge;
import maps.gml.GMLObject;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.EdgeDecorator;
import maps.gml.view.LineEdgeDecorator;

public class DeleteEdgeTool
extends AbstractTool {
    private static final Color HIGHLIGHT_COLOUR = Color.BLUE;
    private Listener listener = new Listener();
    private EdgeDecorator edgeHighlight = new LineEdgeDecorator(HIGHLIGHT_COLOUR);
    private GMLEdge edge;

    public DeleteEdgeTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Delete edge";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
        this.edge = null;
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllEdgeDecorators();
        this.editor.getViewer().repaint();
    }

    private void highlightEdge(GMLEdge newEdge) {
        if (this.edge == newEdge) {
            return;
        }
        if (this.edge != null) {
            this.editor.getViewer().clearEdgeDecorator(this.edge);
        }
        this.edge = newEdge;
        if (this.edge != null) {
            this.editor.getViewer().setEdgeDecorator(this.edgeHighlight, this.edge);
        }
        this.editor.getViewer().repaint();
    }

    private class DeleteEdgeEdit
    extends AbstractUndoableEdit {
        private GMLEdge edge;
        private Collection<GMLObject> deleted;

        public DeleteEdgeEdit(GMLEdge edge, Collection<GMLObject> deleted) {
            this.edge = edge;
            this.deleted = deleted;
        }

        @Override
        public void undo() {
            super.undo();
            DeleteEdgeTool.this.editor.getMap().addEdge(this.edge);
            DeleteEdgeTool.this.editor.getMap().add(this.deleted);
            DeleteEdgeTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            DeleteEdgeTool.this.editor.getMap().removeEdge(this.edge);
            DeleteEdgeTool.this.editor.getViewer().repaint();
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                Collection<GMLObject> deleted = DeleteEdgeTool.this.editor.getMap().removeEdge(DeleteEdgeTool.this.edge);
                DeleteEdgeTool.this.editor.getViewer().repaint();
                DeleteEdgeTool.this.editor.setChanged();
                DeleteEdgeTool.this.editor.addEdit(new DeleteEdgeEdit(DeleteEdgeTool.this.edge, deleted));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = DeleteEdgeTool.this.editor.snap(DeleteEdgeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y));
            DeleteEdgeTool.this.highlightEdge(DeleteEdgeTool.this.editor.getMap().findNearestEdge(c.getX(), c.getY()));
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = DeleteEdgeTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

