/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLCoordinates;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;
import maps.gml.view.EdgeDecorator;
import maps.gml.view.LineEdgeDecorator;
import maps.gml.view.NodeDecorator;
import maps.gml.view.RectangleOverlay;
import maps.gml.view.SquareNodeDecorator;

public class DeleteNodeTool
extends AbstractTool {
    private static final Color HIGHLIGHT_COLOUR = Color.BLUE;
    private static final int HIGHLIGHT_SIZE = 6;
    private static final Color OVERLAY_COLOUR = new Color(0, 0, 128, 128);
    private Listener listener = new Listener();
    private NodeDecorator nodeHighlight = new SquareNodeDecorator(HIGHLIGHT_COLOUR, 6);
    private EdgeDecorator edgeHighlight = new LineEdgeDecorator(HIGHLIGHT_COLOUR);
    private GMLNode selected = null;
    private Collection<GMLEdge> attachedEdges = new HashSet<GMLEdge>();
    private GMLCoordinates pressPoint;
    private GMLCoordinates dragPoint;
    private RectangleOverlay overlay = new RectangleOverlay(OVERLAY_COLOUR, true);

    public DeleteNodeTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Delete node";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
        this.selected = null;
        this.attachedEdges.clear();
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
        this.editor.getViewer().clearAllNodeDecorators();
        this.editor.getViewer().clearAllEdgeDecorators();
        this.editor.getViewer().removeOverlay(this.overlay);
        this.editor.getViewer().repaint();
    }

    private void highlightNode(GMLNode node) {
        if (this.selected == node) {
            return;
        }
        if (this.selected != null) {
            this.editor.getViewer().clearNodeDecorator(this.selected);
            this.editor.getViewer().clearEdgeDecorator(this.attachedEdges);
        }
        this.selected = node;
        this.attachedEdges.clear();
        if (this.selected != null) {
            this.attachedEdges.addAll(this.editor.getMap().getAttachedEdges(this.selected));
            this.editor.getViewer().setNodeDecorator(this.nodeHighlight, this.selected);
            this.editor.getViewer().setEdgeDecorator(this.edgeHighlight, this.attachedEdges);
        }
        this.editor.getViewer().repaint();
    }

    private void removeNodes() {
        double xMin = Math.min(this.pressPoint.getX(), this.dragPoint.getX());
        double xMax = Math.max(this.pressPoint.getX(), this.dragPoint.getX());
        double yMin = Math.min(this.pressPoint.getY(), this.dragPoint.getY());
        double yMax = Math.max(this.pressPoint.getY(), this.dragPoint.getY());
        Collection<GMLNode> nodes = this.editor.getMap().getNodesInRegion(xMin, yMin, xMax, yMax);
        HashMap<GMLNode, Collection<GMLObject>> deleted = new HashMap<GMLNode, Collection<GMLObject>>();
        for (GMLNode next : nodes) {
            deleted.put(next, this.editor.getMap().removeNode(next));
        }
        this.editor.getViewer().repaint();
        this.editor.setChanged();
        this.editor.addEdit(new DeleteNodesEdit(nodes, deleted));
    }

    private class DeleteNodesEdit
    extends AbstractUndoableEdit {
        private Collection<GMLNode> nodes;
        private Map<GMLNode, Collection<GMLObject>> deletedObjects;

        public DeleteNodesEdit(Collection<GMLNode> nodes, Map<GMLNode, Collection<GMLObject>> deletedObjects) {
            this.nodes = nodes;
            this.deletedObjects = deletedObjects;
        }

        @Override
        public void undo() {
            super.undo();
            for (GMLNode next : this.nodes) {
                Collection<GMLObject> deleted = this.deletedObjects.get(next);
                DeleteNodeTool.this.editor.getMap().addNode(next);
                DeleteNodeTool.this.editor.getMap().add(deleted);
            }
            DeleteNodeTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            for (GMLNode next : this.nodes) {
                Collection<GMLObject> deleted = this.deletedObjects.get(next);
                DeleteNodeTool.this.editor.getMap().removeNode(next);
                DeleteNodeTool.this.editor.getMap().remove(deleted);
            }
            DeleteNodeTool.this.editor.getViewer().repaint();
        }
    }

    private class DeleteNodeEdit
    extends AbstractUndoableEdit {
        private GMLNode node;
        private Collection<GMLObject> deletedObjects;

        public DeleteNodeEdit(GMLNode node, Collection<GMLObject> deletedObjects) {
            this.node = node;
            this.deletedObjects = deletedObjects;
        }

        @Override
        public void undo() {
            super.undo();
            DeleteNodeTool.this.editor.getMap().addNode(this.node);
            DeleteNodeTool.this.editor.getMap().add(this.deletedObjects);
            DeleteNodeTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            DeleteNodeTool.this.editor.getMap().removeNode(this.node);
            DeleteNodeTool.this.editor.getMap().remove(this.deletedObjects);
            DeleteNodeTool.this.editor.getViewer().repaint();
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = this.fixEventPoint(e.getPoint());
            GMLCoordinates c = DeleteNodeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
            GMLNode node = DeleteNodeTool.this.editor.getMap().findNearestNode(c.getX(), c.getY());
            DeleteNodeTool.this.highlightNode(node);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (DeleteNodeTool.this.selected == null) {
                return;
            }
            if (e.getButton() == 1) {
                Collection<GMLObject> deleted = DeleteNodeTool.this.editor.getMap().removeNode(DeleteNodeTool.this.selected);
                DeleteNodeTool.this.editor.getViewer().repaint();
                DeleteNodeTool.this.editor.setChanged();
                DeleteNodeTool.this.editor.addEdit(new DeleteNodeEdit(DeleteNodeTool.this.selected, deleted));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                Point p = this.fixEventPoint(e.getPoint());
                DeleteNodeTool.this.pressPoint = DeleteNodeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
                DeleteNodeTool.this.overlay.setLeft(DeleteNodeTool.this.pressPoint.getX());
                DeleteNodeTool.this.overlay.setBottom(DeleteNodeTool.this.pressPoint.getY());
                DeleteNodeTool.this.editor.getViewer().addOverlay(DeleteNodeTool.this.overlay);
                DeleteNodeTool.this.editor.getViewer().repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                Point p = this.fixEventPoint(e.getPoint());
                DeleteNodeTool.this.dragPoint = DeleteNodeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
                DeleteNodeTool.this.overlay.setLeft(Double.NaN);
                DeleteNodeTool.this.overlay.setRight(Double.NaN);
                DeleteNodeTool.this.overlay.setBottom(Double.NaN);
                DeleteNodeTool.this.overlay.setTop(Double.NaN);
                DeleteNodeTool.this.editor.getViewer().removeOverlay(DeleteNodeTool.this.overlay);
                DeleteNodeTool.this.editor.getViewer().repaint();
                DeleteNodeTool.this.removeNodes();
                DeleteNodeTool.this.pressPoint = null;
                DeleteNodeTool.this.dragPoint = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (DeleteNodeTool.this.pressPoint != null) {
                Point p = this.fixEventPoint(e.getPoint());
                DeleteNodeTool.this.dragPoint = DeleteNodeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y);
                DeleteNodeTool.this.overlay.setRight(DeleteNodeTool.this.dragPoint.getX());
                DeleteNodeTool.this.overlay.setTop(DeleteNodeTool.this.dragPoint.getY());
                DeleteNodeTool.this.editor.getViewer().repaint();
                DeleteNodeTool.this.highlightNode(null);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = DeleteNodeTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

