/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.entities;

import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardPropertyURN;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.properties.IntProperty;

public class World
extends StandardEntity {
    private IntProperty startTime;
    private IntProperty longitude;
    private IntProperty latitude;
    private IntProperty windForce;
    private IntProperty windDirection;

    public World(EntityID id) {
        super(id);
        this.startTime = new IntProperty((Enum)StandardPropertyURN.START_TIME);
        this.longitude = new IntProperty((Enum)StandardPropertyURN.LONGITUDE);
        this.latitude = new IntProperty((Enum)StandardPropertyURN.LATITUDE);
        this.windForce = new IntProperty((Enum)StandardPropertyURN.WIND_FORCE);
        this.windDirection = new IntProperty((Enum)StandardPropertyURN.WIND_DIRECTION);
        this.registerProperties(new Property[]{this.startTime, this.longitude, this.latitude, this.windForce, this.windDirection});
    }

    public World(World other) {
        super(other);
        this.startTime = new IntProperty(other.startTime);
        this.longitude = new IntProperty(other.longitude);
        this.latitude = new IntProperty(other.latitude);
        this.windForce = new IntProperty(other.windForce);
        this.windDirection = new IntProperty(other.windDirection);
        this.registerProperties(new Property[]{this.startTime, this.longitude, this.latitude, this.windForce, this.windDirection});
    }

    protected Entity copyImpl() {
        return new World(this.getID());
    }

    @Override
    public StandardEntityURN getStandardURN() {
        return StandardEntityURN.WORLD;
    }

    public Property getProperty(String urn) {
        StandardPropertyURN type;
        try {
            type = StandardPropertyURN.fromString(urn);
        }
        catch (IllegalArgumentException e) {
            return super.getProperty(urn);
        }
        switch (type) {
            case START_TIME: {
                return this.startTime;
            }
            case LONGITUDE: {
                return this.longitude;
            }
            case LATITUDE: {
                return this.latitude;
            }
            case WIND_FORCE: {
                return this.windForce;
            }
            case WIND_DIRECTION: {
                return this.windDirection;
            }
        }
        return super.getProperty(urn);
    }

    public IntProperty getStartTimeProperty() {
        return this.startTime;
    }

    public int getStartTime() {
        return this.startTime.getValue();
    }

    public void setStartTime(int startTime) {
        this.startTime.setValue(startTime);
    }

    public boolean isStartTimeDefined() {
        return this.startTime.isDefined();
    }

    public void undefineStartTime() {
        this.startTime.undefine();
    }

    public IntProperty getLatitudeProperty() {
        return this.latitude;
    }

    public int getLatitude() {
        return this.latitude.getValue();
    }

    public void setLatitude(int latitude) {
        this.latitude.setValue(latitude);
    }

    public boolean isLatitudeDefined() {
        return this.latitude.isDefined();
    }

    public void undefineLatitude() {
        this.latitude.undefine();
    }

    public IntProperty getLongitudeProperty() {
        return this.longitude;
    }

    public int getLongitude() {
        return this.longitude.getValue();
    }

    public void setLongitude(int longitude) {
        this.longitude.setValue(longitude);
    }

    public boolean isLongitudeDefined() {
        return this.longitude.isDefined();
    }

    public void undefineLongitude() {
        this.longitude.undefine();
    }

    public IntProperty getWindForceProperty() {
        return this.windForce;
    }

    public int getWindForce() {
        return this.windForce.getValue();
    }

    public void setWindForce(int windForce) {
        this.windForce.setValue(windForce);
    }

    public boolean isWindForceDefined() {
        return this.windForce.isDefined();
    }

    public void undefineWindForce() {
        this.windForce.undefine();
    }

    public IntProperty getWindDirectionProperty() {
        return this.windDirection;
    }

    public int getWindDirection() {
        return this.windDirection.getValue();
    }

    public void setWindDirection(int windDirection) {
        this.windDirection.setValue(windDirection);
    }

    public boolean isWindDirectionDefined() {
        return this.windDirection.isDefined();
    }

    public void undefineWindDirection() {
        this.windDirection.undefine();
    }
}

