/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.score;

import java.util.HashSet;
import java.util.Set;
import rescuecore2.Timestep;
import rescuecore2.config.Config;
import rescuecore2.score.AbstractScoreFunction;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.Civilian;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.PoliceForce;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public class DiscoveryScoreFunction
extends AbstractScoreFunction {
    private Set<EntityID> found;

    public DiscoveryScoreFunction() {
        super("Civilian discovery time");
    }

    public void initialise(WorldModel<? extends Entity> world, Config config) {
        this.found = new HashSet<EntityID>();
    }

    public double score(WorldModel<? extends Entity> world, Timestep timestep) {
        double sum = 0.0;
        for (EntityID next : timestep.getAgentsWithUpdates()) {
            Entity agent = world.getEntity(next);
            if (!this.isPlatoonAgent(agent)) continue;
            ChangeSet perception = timestep.getAgentPerception(next);
            for (EntityID observedID : perception.getChangedEntities()) {
                Entity e;
                if (this.found.contains(observedID) || !((e = world.getEntity(observedID)) instanceof Civilian) || perception.getChangedProperties(observedID).isEmpty()) continue;
                this.found.add(observedID);
                sum += (double)timestep.getTime();
            }
        }
        return sum;
    }

    private boolean isPlatoonAgent(Entity e) {
        return e instanceof FireBrigade || e instanceof PoliceForce || e instanceof AmbulanceTeam;
    }
}

