/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.view;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.view.StandardViewLayer;
import rescuecore2.view.RenderedObject;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public abstract class StandardEntityViewLayer<T extends StandardEntity>
extends StandardViewLayer {
    protected List<T> entities;
    private Class<T> clazz;

    protected StandardEntityViewLayer(Class<T> clazz) {
        this.clazz = clazz;
        this.entities = new ArrayList<T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle2D view(Object ... objects) {
        List<T> list = this.entities;
        synchronized (list) {
            this.entities.clear();
            this.preView();
            Rectangle2D result = super.view(objects);
            this.postView();
            return result;
        }
    }

    @Override
    protected void viewObject(Object o) {
        super.viewObject(o);
        if (this.clazz.isAssignableFrom(o.getClass())) {
            this.entities.add(this.clazz.cast(o));
        }
        if (o instanceof WorldModel) {
            WorldModel wm = (WorldModel)o;
            for (Entity next : wm) {
                this.viewObject(next);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RenderedObject> render(Graphics2D g, ScreenTransform transform, int width, int height) {
        List<T> list = this.entities;
        synchronized (list) {
            ArrayList<RenderedObject> result = new ArrayList<RenderedObject>();
            for (StandardEntity next : this.entities) {
                result.add(new RenderedObject((Object)next, this.render(next, g, transform)));
            }
            return result;
        }
    }

    public abstract Shape render(T var1, Graphics2D var2, ScreenTransform var3);

    protected void preView() {
    }

    protected void postView() {
    }
}

