/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.element;

import java.util.ArrayList;

/**
 *
 * @author masaru
 */
public class TagElement extends Element {
    
    @Override public boolean isTagElement() { return true; }
    @Override public boolean isTextElement() { return false; }
    
    private String key_;
    private Attributes attributes_;
    Element[] children_;
    private boolean is_empty_;
    private boolean is_pi_;
    
    public TagElement(String key) {
        if(key == null) throw new NullPointerException("key is null");
        key_ = key;
        attributes_ = Attributes.EmptySet;
        children_ = null;
    }
    public TagElement(String key, String value) {
        if(key == null) throw new NullPointerException("key is null");
    	key_ = key;
    	attributes_ = Attributes.EmptySet;
    	setValue(value);
    }

    public String getKey() {
        return key_;
    }


    
    // attribute
    public void addAttribute(Attribute attribute) {
       if(attributes_==Attributes.EmptySet)
           attributes_ = new Attributes();
       attributes_.add(attribute);
    }
    public void setAttribute(Attribute attribute) {
       if(attributes_==Attributes.EmptySet)
           attributes_ = new Attributes();
       attributes_.set(attribute);
    }
    public void setAttribute(String name, String value) {
        setAttribute(new Attribute(name, value));
    }
    public void setAttributes(Attributes attributes) {
        if(attributes==null)
            attributes = Attributes.EmptySet;
        else
            attributes_ = attributes;
    }
    public Attributes getAttributes() {
        return attributes_;
    }
    public String getAttributeValue(String attribute_name) {
        return attributes_.getValue(attribute_name);
    }
    public String getAttributeValue(String attribute_name, String return_if_return_value_is_null) {
        return attributes_.getValue(attribute_name, return_if_return_value_is_null);
    }


    
    // children
    public void setChildren(Element... children) {
        for(int i=0;i<children.length;i++)
            if(children[i]==null) {
                children = removeNullElements(children);
                break;
            }
        setEmpty(false);
        setPI(false);
        children_ = children;
    }
	public void addChild(Element child) {
		addChildren(child);
	}
	public void addChildren(Element... children) {
		Element[] oldchildren = getChildren();
		Element[] newchildren = new Element[oldchildren.length+children.length];
		System.arraycopy(oldchildren, 0, newchildren, 0, oldchildren.length);
		System.arraycopy(children, 0, newchildren, oldchildren.length, children.length);
		setChildren(newchildren);
	}
    public Element[] getChildren() {
        return children_;
    }
    public TagElement[] getTagChildren() {
        int tag_count = 0;
        if(children_==null) return null;
        for(int i=0;i<children_.length;i++)
            if(children_[i].isTagElement()) tag_count++;
        TagElement[] tag_children = new TagElement[tag_count];
        tag_count = 0;
        for(int i=0;i<children_.length;i++)
            if(children_[i].isTagElement())
                tag_children[tag_count++] = (TagElement)children_[i];
        return tag_children;
    }
    public TagElement getTagChild(String key) {
        for(int i=0;i<children_.length;i++)
            if(children_[i].isTagElement())
                if(((TagElement)children_[i]).getKey().equals(key))
                    return (TagElement)children_[i];
        return null;
    }
    public TagElement[] getTagChildren(String key) {
        ArrayList<TagElement> list = new ArrayList<TagElement>();
        for(int i=0;i<children_.length;i++)
            if(children_[i].isTagElement()) {
                TagElement tag = ((TagElement)children_[i]);
                if(tag.getKey().equals(key))
                    list.add(tag);
            }
        return list.toArray(new TagElement[]{});
    }
    
    public String getChildValue(String key) {
        return getChildValue(key, null);
    }
    public String getChildValue(String key, String return_if_value_is_null) {
        TagElement tag = getTagChild(key);
        
        if(tag==null) return return_if_value_is_null;
        
        String value = tag.getValue();
        if(value!=null)
            return value;
        else
            return return_if_value_is_null;
            
    }
    public String[] getChildValues(String key) {
        return getChildValues(key, null);
    }
    public String[] getChildValues(String key, String return_if_value_is_null) {
        TagElement[] tag = getTagChildren(key);
        String[] result = new String[tag.length];
        
        if(tag==null) return new String[]{return_if_value_is_null};
        
        for(int i=0;i<tag.length;i++) {
            String value = tag[i].getValue();
            result[i] = (value!=null ? value : return_if_value_is_null);
        }
        return result;
    }

    
    /**
     * all text value
     * @return
     */
    public String getValue() {
        if(children_==null || children_.length==0) return null;
        StringBuffer sb = new StringBuffer();
        for(int i=0;i<children_.length;i++)
            if(children_[i].isTextElement())
                sb.append(((TextElement)children_[i]).getValue());
        return sb.toString();
    }
    public void setValue(String value) {
        setChildren(new TextElement(value));
    }
    
    
    
    
    // flags
    public void setEmpty(boolean is_empty) {
        is_empty_ = is_empty;
    }
    public boolean isEmpty() {
        return is_empty_;
    }
    public void setPI(boolean is_pi) {
        is_pi_ = is_pi;
    }
    /**
     * <div>PI tag or xml definition</div>
     * <div>
     * &lt;? ... ?&gt;<br/>
     * e.x.<br/>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;<br/>
     * </div>
     * @return is pi tag
     */
    public boolean isPI() {
        return is_pi_;
    }
    
    public static Element[] removeNullElements(Element[] elements) {
        ArrayList<Element> list = new ArrayList<Element>();
        for(int i=0;i<elements.length;i++)
            if(elements != null)
                list.add(elements[i]);
        return list.toArray(new Element[]{});
    }
    
    // toString
    public String toString() {
        return toString(0);
    }
    public String toString(int s) {
        String space = putTab(s);
        StringBuffer sb = new StringBuffer(space);
        sb.append("<");
        if(is_pi_) sb.append("?");
        sb.append(key_);
        if(attributes_.size()>0)
            sb.append(" ").append(attributes_);

        if(is_pi_) {
            sb.append("?>\n");
            return sb.toString();
        }else if(is_empty_) {
            sb.append("/>\n");
            return sb.toString();
        } else {
            sb.append(">");
            if(children_==null || children_.length==1 && children_[0] instanceof TextElement);
            else sb.append("\n");
        }
        
        if(children_ != null){
            for(int i=0;i<children_.length;i++) {
                if(children_[i] != null)
                    sb.append(children_[i].toString(s+1));
                else
                    sb.append("<!-- Null object (this is bug! children must not be Null) -->");
            }
        }
        if(children_==null || children_.length==1 && children_[0] instanceof TextElement);
        else sb.append(space);
        sb.append("</").append(key_).append(">\n");
        return sb.toString();
    }
}
