package org.util.xml.io;

import java.io.*;
import java.awt.HeadlessException;
import javax.swing.*;

import org.util.xml.parse.*;
import org.util.xml.element.*;

public class XMLConfigManager {

    private File config_file_;
    private TagElement config_element_;
    
    public XMLConfigManager() throws IOException {
        initialize(false);
    }
    public XMLConfigManager(String file_name) throws IOException {
        this(new File(new File(System.getProperty("user.dir")), file_name));
    }
    public XMLConfigManager(File config_file) throws IOException {
        config_file_ = config_file;
        initialize(true);
    }
    public XMLConfigManager(File config_file, boolean b) throws IOException {
        config_file_ = config_file;
        initialize(b);
    }
    public void initialize(boolean b) throws IOException {
        if(config_file_ != null && !config_file_.exists()) {
            if (b) {
                try {
                    String message = "Config file does not exists.\n\t Do you want to create config file?";
                    int result = JOptionPane.showConfirmDialog(null, message, "select", JOptionPane.YES_NO_OPTION);
                    if(result == JOptionPane.YES_OPTION) {
                        config_file_.createNewFile();
                    }
                }
                catch (HeadlessException e){
                    initialize(false);
                    return;
                }
            }
            else {
                config_file_.createNewFile();
            }
        }
        inputSetting();
    }
    public void initialize() throws Exception {
        if(!config_file_.exists()) {
            String message = "Config file does not exists.\n\t Do you want to create config file?";
            int result = JOptionPane.showConfirmDialog(null, message, "select", JOptionPane.YES_NO_OPTION);
            if(result == JOptionPane.YES_OPTION) {
                config_file_.createNewFile();
            }
        }
        inputSetting();
    }
    public TagElement getTag(String full_key) {
        String[] keys = full_key.split("/");
        TagElement tmp = getTag();
        for(int i=0;i<keys.length;i++) {
            TagElement ta = null;
            try{
                ta = tmp.getTagChild(keys[i]);
            }catch(Exception e){}
            if(ta == null) {
                Element[] tmp_elements = tmp.getChildren();
                if(tmp_elements != null && tmp_elements.length!=0) {
                    Element[] new_elements = new Element[tmp_elements.length+1];
                    for(int j=0;j<tmp_elements.length;j++)
                        new_elements[j] = tmp_elements[j];
                    try{
                        ta = new TagElement(keys[i]);
                        new_elements[new_elements.length-1] = ta;
                        tmp.setChildren(new_elements);
                    }catch(Exception e){
                        e.printStackTrace();
                    }
                } else {
                    try{
                        ta = new TagElement(keys[i]);
                        tmp.setChildren(ta);
                    }catch(Exception e){
                        e.printStackTrace();
                    }
                }
                try{
                    outputSetting();
                }catch(Exception e) {
                    e.printStackTrace();
                }
            }
            tmp = ta;
        }
        return tmp;
    }
    
    public double getDouble(String full_key, double value) {
        return Double.parseDouble(getValue(full_key, String.valueOf(value)));
    }
    public int getInt(String full_key, int value) {
        return Integer.parseInt(getValue(full_key, String.valueOf(value)));
    }
    public boolean getBoolean(String full_key, boolean value) {
        return "true".equals(getValue(full_key, (value ? "true" : "false") ));
    }

    public String getValue(String full_key, String value) {
        String[] keys = full_key.split("/");
        TagElement tmp = getTag();
        for(int i=0;i<keys.length;i++) {
            TagElement ta = null;
            try{
                ta = tmp.getTagChild(keys[i]);
            }catch(Exception e){}
            if(ta == null) {
                Element[] tmp_elements = tmp.getChildren();
                if(tmp_elements != null && tmp_elements.length!=0) {
                    Element[] new_elements = new Element[tmp_elements.length+1];
                    for(int j=0;j<tmp_elements.length;j++)
                        new_elements[j] = tmp_elements[j];
                    try{
                        ta = new TagElement(keys[i]);
                        new_elements[new_elements.length-1] = ta;
                        tmp.setChildren(new_elements);
                    }catch(Exception e){
                        e.printStackTrace();
                    }
                } else {
                    try{
                        ta = new TagElement(keys[i]);
                        tmp.setChildren(ta);
                    }catch(Exception e){
                        e.printStackTrace();
                    }
                }
                try{
                    outputSetting();
                }catch(Exception e) {
                    e.printStackTrace();
                }
            }
            tmp = ta;
        }
        String result_value = tmp.getValue();
        if(result_value==null || result_value.length()==0) {
            tmp.setValue(value);
            try{
                outputSetting();
            }catch(Exception e) {
                e.printStackTrace();
            }
        }
        return tmp.getValue();
    }

    public void setValue(String full_key, String value) {
        String[] keys = full_key.split("/");
        TagElement tmp = getTag();
        for(int i=0;i<keys.length;i++) {
            TagElement ta = null;
            try{
                ta = tmp.getTagChild(keys[i]);
            }catch(Exception e){}
            if(ta == null) {
                Element[] tmp_elements = tmp.getChildren();
                if(tmp_elements != null && tmp_elements.length!=0) {
                    Element[] new_elements = new Element[tmp_elements.length+1];
                    for(int j=0;j<tmp_elements.length;j++)
                        new_elements[j] = tmp_elements[j];
                    try{
                        ta = new TagElement(keys[i]);
                        new_elements[new_elements.length-1] = ta;
                        tmp.setChildren(new_elements);
                    }catch(Exception e){
                        e.printStackTrace();
                    }
                } else {
                    try{
                        ta = new TagElement(keys[i]);
                        tmp.setChildren(ta);
                    }catch(Exception e){
                        e.printStackTrace();
                    }
                }
                try{
                    outputSetting();
                }catch(Exception e) {
                    e.printStackTrace();
                }
            }
            tmp = ta;
        }
        tmp.setValue(value);
        try{
            outputSetting();
        }catch(Exception e) {
            e.printStackTrace();
        }
    }

    
    public TagElement getTag() {
        return config_element_;
    }
    
    public void inputSetting() throws IOException {
        if(config_file_!=null && config_file_.exists())
            try{
                ElementParser parser = new ElementParser(new FileInputStream(config_file_));
                parser.parse();
                config_element_ = parser.getFirstPlainTagElement();
            }
            catch(IOException e) {
                e.printStackTrace();
            }
            catch(XMLParseException e) {
                e.printStackTrace();
            }
	
        if(config_element_ == null || !config_element_.getKey().equals("config")) {
            config_element_ = new TagElement("config");
            try {
                outputSetting();
            } catch(IOException e){}
        }
        config_element_.setTabText("\t");
    }
    public void outputSetting() throws IOException {
        if(config_file_ == null || !config_file_.exists()) return ;
        String config_text = config_element_.toString();
        System.out.println(config_text);
        BufferedWriter bw = new BufferedWriter(new FileWriter(config_file_));
        bw.write(config_text);
        bw.flush();
        bw.close();
    }
    public String toString() {
        return "file: " + config_file_ + "\n" + config_element_.toString();
    }
}
