/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.parse;

import java.util.ArrayList;
import org.util.xml.parse.ElementParser;

/**
 *
 * @author masaru
 */
public class EqParser extends ParseElement {

    private SpaceParser space_parser_;
    
    @Override
    public boolean match(char c) {
        return (isSpace(c) || c=='=');
    }

    @Override
    public int parse(int c, ElementParser parser) throws Exception {
        if(space_parser_==null) space_parser_ = new SpaceParser();
        int next_word_ = -1;
        int state = 0;
        while(true) {
            if(state == 0) {
                if(isSpace(c)) ;
                else if(c=='=') state = 1;
                else {
                    parser.error(this);
                    return escape(parser, "cannot read = ("+(char)c+")");
                }
            }else if(state == 1) {
                if(isSpace(c)) ;
                else {
                    next_word_ = c;
                    break;
                }
            }
            c = parser.getChar();
        }
        return next_word_;
    }
    
    @Override
    public void listDependentParser(ArrayList<ParseElement> list) {
        for(int i=0;i<list.size();i++)
            if(list.get(i) instanceof SpaceParser) {
                space_parser_ = (SpaceParser)list.get(i);
                return;
            }
        space_parser_ = new SpaceParser();
        list.add(space_parser_);
    }
    public int escape (ElementParser parser,String message) throws Exception {
        try{throw new Exception("mark");}catch(Exception e){e.printStackTrace();}
        System.out.println("this documents has error."+message);
        System.out.println("skip---------------------");
        int c = parser.get();
        while(c!='>' && c!=-1) System.out.print((char)(c=parser.get()));
        System.out.println("\n-------------------------");
        return parser.get();
    }
}
