/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.parse;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.IOException;
import org.util.xml.parse.policy.ParserPolicy;
import org.util.xml.element.Attribute;
import org.util.xml.element.TagElement;
import org.util.xml.element.TextElement;

/**
 *
 * @author masaru
 */
public class ElementPartParser extends ParseElement {

    // parsers
    protected NameParser name_parser_;
    protected SpaceParser space_parser_;
    protected AttributeParser attribute_parser_;
    protected TextElementParser text_element_parser_;
    protected CommentInnerTagElementParser comment_inner_tag_element_parser_;

    protected ParserPolicy policy_;
    
    protected boolean is_novalue_occuered_;
    protected boolean is_error_;
    
    protected TagElement tag_element_;
    protected TextElement text_element_;
    protected String endtag_name_;
    protected boolean is_start_tag_;
    protected StringBuffer error_text_;
    
    public ElementPartParser() {
        this(null);
    }
    
    public ElementPartParser(ParserPolicy policy) {
        policy_ = policy;

        name_parser_ = new NameParser();
        space_parser_ = new SpaceParser();
        attribute_parser_ = new AttributeParser();
        text_element_parser_ = new TextElementParser();
        comment_inner_tag_element_parser_ = new CommentInnerTagElementParser();
        error_text_ = new StringBuffer();
    }
    
    @Override
    public boolean match(char c) {
        return c=='<';
    }

    @Override
        public int parse(int c, ElementParser parser) throws XMLParseException, IOException {

        is_error_ = false;
        is_start_tag_ = false;
        endtag_name_ = null;
        text_element_ = null;
        tag_element_ = null;
        is_novalue_occuered_ = false;
        
        int next_word_ = -1;
        int state = 0;
try{
    
        while(true) {
            
            //System.out.println("state:"+state+"|"+(char)c);
            if(state == 0) {
                if(c=='<') state = 2;
                else if(isSpace(c)) ;
                else if(text_element_parser_.match((char)c)){
                    c = text_element_parser_.parse(c, parser);
                    text_element_ = new TextElement(text_element_parser_.getReturnValue());
                    break;
                } else escape(parser, "parse error: cannot read tag: state=0 ???");
            }else if(state == 1) {
                if(c=='<') state = 2;
                else throw new XMLParseException("parse error: cannot read tag: state=1 ???");
            }else if(state == 2) {
                if((c=='/')) state = 6;
                else if(c=='?') {
                    state = 9;
                } else if(comment_inner_tag_element_parser_.match((char)c)) {
                    c = comment_inner_tag_element_parser_.parse(c, parser);
                    text_element_ = comment_inner_tag_element_parser_.getResult();
                    break;
                } else if(name_parser_.match((char)c)) {
                    c = name_parser_.parse(c, parser);
                    String key = name_parser_.getReturnValue();
                    tag_element_ = new TagElement(key);
                    if(policy_ != null && policy_.forceEmptyTag(key))
                        tag_element_.setEmpty(true);
                    else
                        is_start_tag_ = true;
                    state = 10;
                    continue;
                } else throw new XMLParseException("parse error: cannot read tag: this charactar is not allowed at start of tag ("+(char)c+")");
            }else if(state == 3) {
                next_word_ = c;
                break;
            } else if(state == 4) {
                tag_element_.setEmpty(true);
                is_start_tag_ = false;
                if(c=='>') break;
                else throw new XMLParseException("parse error: cannot read tag: [<.../"+(char)c+"]");
            }else if(state == 6) {
                c = name_parser_.parse(c, parser);
                endtag_name_ = name_parser_.getReturnValue();
                state = 7;
                continue;
            }else if(state == 7) {
                if(c=='>') {
                    break;
                } else if(space_parser_.match((char)c)) {
                    c = space_parser_.parse(c, parser);
                    continue;
                } else throw new XMLParseException("parse error: cannot read tag: state=7 cannot find '>'");
            }else if(state == 9) {
                c = name_parser_.parse(c, parser);
                tag_element_ = new TagElement(name_parser_.getReturnValue());
                tag_element_.setPI(true);
                state = 10;
                continue;
            }else if(state == 10) {
                if(space_parser_.match((char)c)) {
                    c = space_parser_.parse(c, parser);
                    state = 11;
                    continue;
                } else {
                    if(tag_element_.isPI()){
                        if(c=='?') state = 4;
                        else return escape(parser,"in <? ... ?> tag");
                    } else {
                        if(c=='>') break;
                        else if(c=='/') state = 4;
                        else if(is_novalue_occuered_) {
                            c = attribute_parser_.parse(c, parser);
                            Attribute attribute = attribute_parser_.getAttribute();
                            is_novalue_occuered_ = attribute.isNovalue();
                            tag_element_.addAttribute(attribute);
                            state = 10;
                            continue;
                        } else return escape(parser,"cannot read "+(char)c);
                    }
                }
            }else if(state == 11) {
                if(attribute_parser_.match((char)c)) {
                    c = attribute_parser_.parse(c, parser);
                    Attribute attribute = attribute_parser_.getAttribute();
                    is_novalue_occuered_ = attribute.isNovalue();
                    tag_element_.addAttribute(attribute);
                    state = 10;
                    continue;
                } else {
                    if(tag_element_.isPI()){
                        if(c=='?') state = 4;
                        else throw new XMLParseException("parse error: cannot read tag: state=11");
                    } else {
                        if(c=='>') break;
                        else if(c=='/') state = 4;
                        else throw new XMLParseException("parse error: cannot read tag: state=11");
                    }
                }
            }
            if(state==0)
                c = parser.get();
            else
                c = parser.getChar();
        }
        
} catch(IOException e) {
    is_error_ = true;
    StringWriter sw = new StringWriter();
    e.printStackTrace(new PrintWriter(sw));
    if(policy_.throwExceptionIfDocumentHasError())
        error_text_.append(sw.toString());
    parser.escape(e.getMessage());
} catch(XMLParseException e) {
    is_error_ = true;
    StringWriter sw = new StringWriter();
    e.printStackTrace(new PrintWriter(sw));
    if(policy_.throwExceptionIfDocumentHasError())
        error_text_.append(sw.toString());
    parser.escape(e.getMessage());
}
        
        int result = -1;
        try {
            if(text_element_!=null)
                result = c;
            else
                result = parser.get();
        }
        catch (IOException e) {
            throw new XMLParseException(e.toString());
        }
        return result;
    }
    
    public int escape (ElementParser parser,String message) throws XMLParseException, IOException {
        //try{throw new Exception("mark");}catch(Exception e){e.printStackTrace();}
        is_error_ = true;
        System.err.println("this documents has error: "+message);
        System.err.println("skip---------------------");
        int c = parser.get();
        System.err.print((char)c);
        while(c!='>' && c!=-1) System.err.print((char)(c=parser.get()));
        //        for(int i=0;i<3000;i++) System.err.print((char)(c=parser.get()));
        System.err.println("\n-------------------------");
        return parser.get();
    }

    public boolean isTagElement() {
        return (tag_element_!=null);
    }
    public boolean isTextElement() {
        return (text_element_!=null);
    }
    public boolean isStartTag() {
        return is_start_tag_;
    }
    public TextElement getTextElement() {
        return text_element_;
    }
    public TagElement getTagElement() {
        return tag_element_;
    }
    public String getEndTagName() {
        return endtag_name_;
    }
}
