/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.parse;

import java.util.ArrayList;
import java.io.IOException;
import org.util.xml.parse.ElementParser;

/**
 *
 * @author masaru
 */
public class NameParser extends ParseElement {

    private String result_value_;
    
    @Override
    public boolean match(char c) {
        return allow(c);
    }

    @Override
        public int parse(int c, ElementParser parser) throws XMLParseException, IOException {
        
        StringBuffer sb = new StringBuffer();
        int next_word_ = -1;
        int state = 0;
        while(true) {
            if(state == 0) {
                if(allow(c)) {
                    state = 1;
                    sb.append((char)c);
                } else
                    throw new XMLParseException("parse error: cannot read name: this char is not allowd ("+(char)c+")");
            }else if(state == 1) {
                if(allow(c)) sb.append((char)c);
                else {
                    next_word_ = c;
                    break;
                }
            }
            c = parser.get();
        }
        result_value_ = sb.toString();
        return next_word_;
    }
    
    public boolean allow(int c) {
        return (!isSpace(c) && (c!='<') && (c!='>') && (c!='/') && (c!='!')
                && (c!='?') && (c!='=') && (c!='\"') && (c!='\'') && (c!=-1));
    }

    @Override
    public String getReturnValue() {
        return result_value_.toString();
    }
}
