/*
 * Decompiled with CFR 0.152.
 */
package commlib.components;

import commlib.message.RCRSCSMessage;
import commlib.message.RCRSCSMessageConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import rescuecore2.messages.Command;
import rescuecore2.standard.components.StandardAgent;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.messages.AKSpeak;

abstract class RCRSCSAgent<E extends StandardEntity>
extends StandardAgent<E> {
    RCRSCSMessageConverter messageConverter;
    private List<RCRSCSMessage> messageList = new ArrayList<RCRSCSMessage>();
    protected List<RCRSCSMessage> receivedMessageList = new ArrayList<RCRSCSMessage>();
    private int messageChannel = -1;

    protected void postConnect() {
        super.postConnect();
        this.messageConverter = new RCRSCSMessageConverter(((StandardEntity)this.me()).getID(), (StandardWorldModel)this.model, this.config);
    }

    protected final void setMessageChannel(int channel) {
        this.messageChannel = channel;
    }

    protected final int getMessageChannel() {
        return this.messageChannel;
    }

    protected final void receiveMessage(Collection<Command> heard) {
        this.receivedMessageList = new ArrayList<RCRSCSMessage>();
        for (Command command : heard) {
            AKSpeak speak;
            if (!(command instanceof AKSpeak) || (speak = (AKSpeak)command).getChannel() != this.messageChannel) continue;
            this.receivedMessageList.addAll(this.messageConverter.bytesToMessageList(speak.getContent()));
        }
    }

    protected final void addMessage(RCRSCSMessage message) {
        this.messageList.add(message);
    }

    protected final void sendMessage(int time) {
        byte[] data = this.messageConverter.messageToBytes(this.messageList);
        if (data != null) {
            super.sendSpeak(time, this.messageChannel, data);
        }
    }

    protected final void sendSpeak(int time, int channel, byte[] data) {
        if (channel == this.messageChannel) {
            this.sendMessage(time);
        } else {
            super.sendSpeak(time, this.messageChannel, data);
        }
    }

    protected final int getMessageSize() {
        return this.messageList.size();
    }
}

