/*
 * Decompiled with CFR 0.152.
 */
package commlib.information;

import commlib.data.DataType;
import commlib.data.EntityIDData;
import commlib.data.ValueData;
import commlib.information.WorldInformation;
import commlib.message.BaseMessageType;
import java.util.EnumMap;
import java.util.List;
import rescuecore2.misc.Pair;
import rescuecore2.worldmodel.EntityID;

public class VictimInformation
extends WorldInformation {
    public VictimInformation(int time, EntityID vicID, EntityID area, int hp, int buriedness, int damage) {
        super(BaseMessageType.VICTIM, time);
        this.setData(new EntityIDData(DataType.HUMAN, vicID));
        this.setData(new EntityIDData(DataType.AREA, area));
        this.setData(new ValueData(DataType.HP, hp));
        this.setData(new ValueData(DataType.BURIEDNESS, buriedness));
        this.setData(new ValueData(DataType.DAMAGE, damage));
    }

    public VictimInformation(int time, EntityID vicID, EntityID area, int hp, int buriedness, int damage, Pair<Integer, Integer> cor) {
        super(BaseMessageType.VICTIM_WITH_COORDINATE, time);
        this.setData(new EntityIDData(DataType.HUMAN, vicID));
        this.setData(new EntityIDData(DataType.HUMAN, area));
        this.setData(new ValueData(DataType.HP, hp));
        this.setData(new ValueData(DataType.BURIEDNESS, buriedness));
        this.setData(new ValueData(DataType.DAMAGE, damage));
        super.setCoorinate(cor);
    }

    public VictimInformation(BaseMessageType type, List<Integer> bitList, int offset, EnumMap<DataType, Integer> bitSizeMap) {
        super(type, bitList, offset, bitSizeMap);
    }

    public EntityID getVictimID() {
        return super.getID(DataType.HUMAN, 0);
    }

    public int getHP() {
        return super.getHP(0);
    }

    public int getBuriedness() {
        return super.getBuriedness(0);
    }

    public int getDamage() {
        return super.getDamage(0);
    }

    public EntityID getAreaID() {
        return super.getID(DataType.AREA, 0);
    }

    public Pair<Integer, Integer> getCoodinate() {
        return super.getCoodinate(0);
    }

    @Override
    public EntityID getEntityID() {
        return this.getVictimID();
    }
}

