/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rescuecore2.messages.AbstractMessageComponent;
import rescuecore2.misc.EncodingTools;

public class RawDataComponent
extends AbstractMessageComponent {
    private byte[] data;

    public RawDataComponent(String name) {
        super(name);
    }

    public RawDataComponent(String name, byte[] data) {
        super(name);
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public byte[] getData() {
        byte[] result = new byte[this.data.length];
        System.arraycopy(this.data, 0, result, 0, this.data.length);
        return result;
    }

    public void setData(byte[] newData) {
        this.data = new byte[newData.length];
        System.arraycopy(newData, 0, this.data, 0, newData.length);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.data.length, out);
        out.write(this.data);
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.data = EncodingTools.readBytes(EncodingTools.readInt32(in), in);
    }

    public String toString() {
        return this.getName() + " = " + this.data.length + " bytes of raw data";
    }
}

