/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import rescuecore2.messages.Message;
import rescuecore2.registry.Registry;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;

public final class EncodingTools {
    public static final int INT_32_SIZE = 4;
    private static final Charset CHARSET = Charset.forName("UTF-8");

    private EncodingTools() {
    }

    public static void writeInt32(int i, OutputStream out) throws IOException {
        out.write((byte)(i >> 24) & 0xFF);
        out.write((byte)(i >> 16) & 0xFF);
        out.write((byte)(i >> 8) & 0xFF);
        out.write((byte)i & 0xFF);
    }

    public static void writeInt32(int i, DataOutput out) throws IOException {
        out.write(i);
    }

    public static void writeInt32(int i, byte[] out, int offset) {
        out[offset] = (byte)(i >> 24 & 0xFF);
        out[offset + 1] = (byte)(i >> 16 & 0xFF);
        out[offset + 2] = (byte)(i >> 8 & 0xFF);
        out[offset + 3] = (byte)(i & 0xFF);
    }

    public static int readInt32(InputStream in) throws IOException {
        int first = in.read();
        if (first == -1) {
            throw new EOFException("Broken input pipe. Read 0 bytes of 4.");
        }
        int second = in.read();
        if (second == -1) {
            throw new EOFException("Broken input pipe. Read 1 bytes of 4.");
        }
        int third = in.read();
        if (third == -1) {
            throw new EOFException("Broken input pipe. Read 2 bytes of 4.");
        }
        int fourth = in.read();
        if (fourth == -1) {
            throw new EOFException("Broken input pipe. Read 3 bytes of 4.");
        }
        return first << 24 | second << 16 | third << 8 | fourth;
    }

    public static int readInt32(DataInput in) throws IOException {
        return in.readInt();
    }

    public static int readInt32LE(InputStream in) throws IOException {
        int first = in.read();
        if (first == -1) {
            throw new EOFException("Broken input pipe. Read 0 bytes of 4.");
        }
        int second = in.read();
        if (second == -1) {
            throw new EOFException("Broken input pipe. Read 1 bytes of 4.");
        }
        int third = in.read();
        if (third == -1) {
            throw new EOFException("Broken input pipe. Read 2 bytes of 4.");
        }
        int fourth = in.read();
        if (fourth == -1) {
            throw new EOFException("Broken input pipe. Read 3 bytes of 4.");
        }
        return fourth << 24 | third << 16 | second << 8 | first;
    }

    public static int readInt32(byte[] in, int offset) {
        return in[offset] << 24 | in[offset + 1] << 16 | in[offset + 2] << 8 | in[offset + 3];
    }

    public static int readInt32(byte[] in) {
        return EncodingTools.readInt32(in, 0);
    }

    public static void writeString(String s, OutputStream out) throws IOException {
        byte[] bytes = s.getBytes(CHARSET);
        EncodingTools.writeInt32(bytes.length, out);
        out.write(bytes);
    }

    public static void writeString(String s, DataOutput out) throws IOException {
        byte[] bytes = s.getBytes(CHARSET);
        EncodingTools.writeInt32(bytes.length, out);
        out.write(bytes);
    }

    public static void writeString(String s, byte[] out, int offset) {
        byte[] bytes = s.getBytes(CHARSET);
        EncodingTools.writeInt32(bytes.length, out, offset);
        System.arraycopy(bytes, 0, out, offset + 4, bytes.length);
    }

    public static String readString(InputStream in) throws IOException {
        int read;
        int length = EncodingTools.readInt32(in);
        byte[] buffer = new byte[length];
        for (int count = 0; count < length; count += read) {
            read = in.read(buffer, count, length - count);
            if (read != -1) continue;
            throw new EOFException("Broken input pipe. Read " + count + " bytes of " + length + ".");
        }
        return new String(buffer, CHARSET);
    }

    public static String readString(DataInput in) throws IOException {
        int length = EncodingTools.readInt32(in);
        byte[] buffer = new byte[length];
        in.readFully(buffer);
        return new String(buffer, CHARSET);
    }

    public static String readString(byte[] in) {
        return EncodingTools.readString(in, 0);
    }

    public static String readString(byte[] in, int offset) {
        int length = EncodingTools.readInt32(in, offset);
        byte[] buffer = new byte[length];
        System.arraycopy(in, offset + 4, buffer, 0, length);
        return new String(buffer, CHARSET);
    }

    public static byte[] readBytes(int size, InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[size];
        for (int total = 0; total < size; total += read) {
            read = in.read(buffer, total, size - total);
            if (read != -1) continue;
            throw new EOFException("Broken input pipe. Read " + total + " bytes of " + size + ".");
        }
        return buffer;
    }

    public static byte[] readBytes(int size, DataInput in) throws IOException {
        byte[] buffer = new byte[size];
        in.readFully(buffer);
        return buffer;
    }

    public static void writeDouble(double d, OutputStream out) throws IOException {
        long bits = Double.doubleToLongBits(d);
        out.write((byte)(bits >> 56) & 0xFF);
        out.write((byte)(bits >> 48) & 0xFF);
        out.write((byte)(bits >> 40) & 0xFF);
        out.write((byte)(bits >> 32) & 0xFF);
        out.write((byte)(bits >> 24) & 0xFF);
        out.write((byte)(bits >> 16) & 0xFF);
        out.write((byte)(bits >> 8) & 0xFF);
        out.write((byte)bits & 0xFF);
    }

    public static void writeDouble(double d, DataOutput out) throws IOException {
        out.writeDouble(d);
    }

    public static void writeDouble(double d, byte[] out, int offset) {
        long bits = Double.doubleToLongBits(d);
        out[offset + 0] = (byte)(bits >> 56 & 0xFFL);
        out[offset + 1] = (byte)(bits >> 48 & 0xFFL);
        out[offset + 2] = (byte)(bits >> 40 & 0xFFL);
        out[offset + 3] = (byte)(bits >> 32 & 0xFFL);
        out[offset + 4] = (byte)(bits >> 24 & 0xFFL);
        out[offset + 5] = (byte)(bits >> 16 & 0xFFL);
        out[offset + 6] = (byte)(bits >> 8 & 0xFFL);
        out[offset + 7] = (byte)(bits & 0xFFL);
    }

    public static double readDouble(InputStream in) throws IOException {
        long[] data = new long[8];
        for (int i = 0; i < data.length; ++i) {
            data[i] = in.read();
            if (data[i] != -1L) continue;
            throw new EOFException("Broken input pipe. Read " + i + " bytes of 8.");
        }
        long result = data[0] << 56 | data[1] << 48 | data[2] << 40 | data[3] << 32 | data[4] << 24 | data[5] << 16 | data[6] << 8 | data[7];
        return Double.longBitsToDouble(result);
    }

    public static double readDouble(DataInput in) throws IOException {
        return in.readDouble();
    }

    public static double readDouble(byte[] in, int offset) {
        long[] parts = new long[8];
        for (int i = 0; i < 8; ++i) {
            parts[i] = in[offset + i];
        }
        long result = parts[0] << 56 | parts[1] << 48 | parts[2] << 40 | parts[3] << 32 | parts[4] << 24 | parts[5] << 16 | parts[6] << 8 | parts[7];
        return Double.longBitsToDouble(result);
    }

    public static double readDouble(byte[] in) {
        return EncodingTools.readDouble(in, 0);
    }

    public static void writeBoolean(boolean b, OutputStream out) throws IOException {
        out.write(b ? 1 : 0);
    }

    public static void writeBoolean(boolean b, DataOutput out) throws IOException {
        out.writeBoolean(b);
    }

    public static void writeBoolean(boolean b, byte[] out, int offset) {
        out[offset] = (byte)(b ? 1 : 0);
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        int b = in.read();
        return b == 1;
    }

    public static boolean readBoolean(DataInput in) throws IOException {
        return in.readBoolean();
    }

    public static boolean readBoolean(byte[] in, int offset) {
        return in[offset] == 1;
    }

    public static boolean readBoolean(byte[] in) {
        return EncodingTools.readBoolean(in, 0);
    }

    public static void reallySkip(InputStream in, long count) throws IOException {
        long next;
        for (long done = 0L; done < count; done += next) {
            next = in.skip(count - done);
            if (next >= 0L) continue;
            throw new EOFException();
        }
    }

    public static void reallySkip(DataInput in, int count) throws IOException {
        int next;
        for (int done = 0; done < count; done += next) {
            next = in.skipBytes(count - done);
            if (next >= 0) continue;
            throw new EOFException();
        }
    }

    public static void writeEntity(Entity e, OutputStream out) throws IOException {
        ByteArrayOutputStream gather = new ByteArrayOutputStream();
        e.write(gather);
        byte[] bytes = gather.toByteArray();
        EncodingTools.writeString(e.getURN(), out);
        EncodingTools.writeInt32(e.getID().getValue(), out);
        EncodingTools.writeInt32(bytes.length, out);
        out.write(bytes);
    }

    public static void writeEntity(Entity e, DataOutput out) throws IOException {
        ByteArrayOutputStream gather = new ByteArrayOutputStream();
        e.write(gather);
        byte[] bytes = gather.toByteArray();
        EncodingTools.writeString(e.getURN(), out);
        EncodingTools.writeInt32(e.getID().getValue(), out);
        EncodingTools.writeInt32(bytes.length, out);
        out.write(bytes);
    }

    public static Entity readEntity(InputStream in) throws IOException {
        String urn = EncodingTools.readString(in);
        if ("".equals(urn)) {
            return null;
        }
        int entityID = EncodingTools.readInt32(in);
        int size = EncodingTools.readInt32(in);
        byte[] content = EncodingTools.readBytes(size, in);
        Entity result = Registry.getCurrentRegistry().createEntity(urn, new EntityID(entityID));
        if (result != null) {
            result.read(new ByteArrayInputStream(content));
        }
        return result;
    }

    public static Entity readEntity(DataInput in) throws IOException {
        String urn = EncodingTools.readString(in);
        if ("".equals(urn)) {
            return null;
        }
        int entityID = EncodingTools.readInt32(in);
        int size = EncodingTools.readInt32(in);
        byte[] content = EncodingTools.readBytes(size, in);
        Entity result = Registry.getCurrentRegistry().createEntity(urn, new EntityID(entityID));
        if (result != null) {
            result.read(new ByteArrayInputStream(content));
        }
        return result;
    }

    public static void writeProperty(Property p, OutputStream out) throws IOException {
        EncodingTools.writeString(p.getURN(), out);
        EncodingTools.writeBoolean(p.isDefined(), out);
        if (p.isDefined()) {
            ByteArrayOutputStream gather = new ByteArrayOutputStream();
            p.write(gather);
            byte[] bytes = gather.toByteArray();
            EncodingTools.writeInt32(bytes.length, out);
            out.write(bytes);
        }
    }

    public static void writeProperty(Property p, DataOutput out) throws IOException {
        EncodingTools.writeString(p.getURN(), out);
        EncodingTools.writeBoolean(p.isDefined(), out);
        if (p.isDefined()) {
            ByteArrayOutputStream gather = new ByteArrayOutputStream();
            p.write(gather);
            byte[] bytes = gather.toByteArray();
            EncodingTools.writeInt32(bytes.length, out);
            out.write(bytes);
        }
    }

    public static Property readProperty(InputStream in) throws IOException {
        String urn = EncodingTools.readString(in);
        if ("".equals(urn)) {
            return null;
        }
        boolean defined = EncodingTools.readBoolean(in);
        Property result = Registry.getCurrentRegistry().createProperty(urn);
        if (defined) {
            int size = EncodingTools.readInt32(in);
            byte[] content = EncodingTools.readBytes(size, in);
            if (result != null) {
                result.read(new ByteArrayInputStream(content));
            }
        }
        return result;
    }

    public static Property readProperty(DataInput in) throws IOException {
        String urn = EncodingTools.readString(in);
        if ("".equals(urn)) {
            return null;
        }
        boolean defined = EncodingTools.readBoolean(in);
        Property result = Registry.getCurrentRegistry().createProperty(urn);
        if (defined) {
            int size = EncodingTools.readInt32(in);
            byte[] content = EncodingTools.readBytes(size, in);
            if (result != null) {
                result.read(new ByteArrayInputStream(content));
            }
        }
        return result;
    }

    public static void writeMessage(Message m, OutputStream out) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        m.write(bytes);
        byte[] content = bytes.toByteArray();
        EncodingTools.writeString(m.getURN(), out);
        EncodingTools.writeInt32(content.length, out);
        out.write(content);
    }

    public static void writeMessage(Message m, DataOutput out) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        m.write(bytes);
        byte[] content = bytes.toByteArray();
        EncodingTools.writeString(m.getURN(), out);
        EncodingTools.writeInt32(content.length, out);
        out.write(content);
    }

    public static Message readMessage(InputStream in) throws IOException {
        String urn = EncodingTools.readString(in);
        if ("".equals(urn)) {
            return null;
        }
        int size = EncodingTools.readInt32(in);
        byte[] content = EncodingTools.readBytes(size, in);
        Message result = Registry.getCurrentRegistry().createMessage(urn, new ByteArrayInputStream(content));
        return result;
    }

    public static Message readMessage(DataInput in) throws IOException {
        String urn = EncodingTools.readString(in);
        if ("".equals(urn)) {
            return null;
        }
        int size = EncodingTools.readInt32(in);
        byte[] content = EncodingTools.readBytes(size, in);
        Message result = Registry.getCurrentRegistry().createMessage(urn, new ByteArrayInputStream(content));
        return result;
    }
}

