/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.gui.DrawingTools;
import rescuecore2.misc.gui.PanZoomListener;
import rescuecore2.misc.gui.ScreenTransform;

public class ShapeDebugFrame
extends JFrame {
    private static final int DISPLAY_WIDTH = 500;
    private static final int DISPLAY_HEIGHT = 500;
    private static final int LEGEND_WIDTH = 500;
    private static final int LEGEND_HEIGHT = 500;
    private static final double ZOOM_TO_OFFSET = 0.1;
    private static final double ZOOM_TO_WIDTH_FACTOR = 1.2;
    private JLabel title;
    private JButton step;
    private JButton cont;
    private ShapeViewer viewer;
    private ShapeInfoLegend legend;
    private CyclicBarrier barrier = new CyclicBarrier(2);
    private boolean enabled;
    private Collection<? extends ShapeInfo> background;
    private boolean backgroundEnabled;
    private JPopupMenu menu;
    private boolean autoZoom;

    public ShapeDebugFrame() {
        this.viewer = new ShapeViewer();
        this.legend = new ShapeInfoLegend();
        this.step = new JButton("Step");
        this.cont = new JButton("Continue");
        this.title = new JLabel();
        this.add((Component)this.title, "North");
        this.add((Component)this.viewer, "Center");
        JPanel buttons = new JPanel(new GridLayout(1, 2));
        buttons.add(this.step);
        buttons.add(this.cont);
        this.add((Component)buttons, "South");
        this.add((Component)this.legend, "East");
        this.legend.setBorder(BorderFactory.createTitledBorder("Legend"));
        this.viewer.setBorder(BorderFactory.createTitledBorder("Shapes"));
        this.step.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ShapeDebugFrame.this.barrier.await();
                }
                catch (InterruptedException ex) {
                }
                catch (BrokenBarrierException brokenBarrierException) {
                    // empty catch block
                }
            }
        });
        this.cont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ShapeDebugFrame.this.deactivate();
                    ShapeDebugFrame.this.barrier.await();
                }
                catch (InterruptedException ex) {
                }
                catch (BrokenBarrierException brokenBarrierException) {
                    // empty catch block
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    ShapeDebugFrame.this.barrier.await();
                }
                catch (InterruptedException ex) {
                }
                catch (BrokenBarrierException brokenBarrierException) {
                    // empty catch block
                }
            }
        });
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ShapeDebugFrame.this.menu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ShapeDebugFrame.this.menu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ShapeDebugFrame.this.menu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                }
            }
        };
        this.addMouseListener(m);
        this.viewer.addMouseListener(m);
        this.enabled = true;
        this.clearBackground();
        this.backgroundEnabled = true;
        this.autoZoom = true;
        this.pack();
        this.menu = new JPopupMenu();
        this.menu.add(new BackgroundAction());
    }

    public void setBackground(Collection<? extends ShapeInfo> back) {
        this.background = back;
        if (this.background == null) {
            this.clearBackground();
        }
    }

    public void clearBackground() {
        this.background = new ArrayList<ShapeInfo>();
    }

    public void setBackgroundEnabled(boolean b) {
        this.backgroundEnabled = b;
    }

    public void setAutozoomEnabled(boolean b) {
        this.autoZoom = b;
    }

    public void show(String description, Collection<? extends ShapeInfo> ... shapes) {
        ArrayList<ShapeInfo> all = new ArrayList<ShapeInfo>();
        for (Collection<? extends ShapeInfo> next : shapes) {
            all.addAll(next);
        }
        this.show(description, (Collection<ShapeInfo>)all);
    }

    public void show(String description, ShapeInfo ... shapes) {
        this.show(description, (Collection<ShapeInfo>)Arrays.asList(shapes));
    }

    public void show(final String description, final Collection<ShapeInfo> shapes) {
        if (!this.enabled) {
            return;
        }
        final ArrayList<ShapeInfo> allShapes = new ArrayList<ShapeInfo>(shapes);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (description == null) {
                    ShapeDebugFrame.this.title.setText("");
                } else {
                    ShapeDebugFrame.this.title.setText(description);
                }
                ShapeDebugFrame.this.legend.setShapes(allShapes);
                ShapeDebugFrame.this.viewer.setShapes(allShapes);
                if (ShapeDebugFrame.this.autoZoom) {
                    ShapeDebugFrame.this.viewer.zoomTo(shapes);
                }
                ShapeDebugFrame.this.repaint();
            }
        });
        try {
            this.barrier.await();
        }
        catch (InterruptedException e) {
        }
        catch (BrokenBarrierException e) {
            // empty catch block
        }
    }

    public void activate() {
        this.enabled = true;
    }

    public void deactivate() {
        this.enabled = false;
        this.setVisible(false);
    }

    private Rectangle2D getBounds(Collection<? extends ShapeInfo> ... shapes) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Collection<? extends ShapeInfo> c : shapes) {
            if (c == null) continue;
            for (ShapeInfo shapeInfo : c) {
                Point2D point;
                Shape bounds = shapeInfo.getBoundsShape();
                if (bounds != null) {
                    Rectangle2D rect = bounds.getBounds2D();
                    minX = Math.min(minX, rect.getMinX());
                    maxX = Math.max(maxX, rect.getMaxX());
                    minY = Math.min(minY, rect.getMinY());
                    maxY = Math.max(maxY, rect.getMaxY());
                }
                if ((point = shapeInfo.getBoundsPoint()) == null) continue;
                minX = Math.min(minX, point.getX());
                maxX = Math.max(maxX, point.getX());
                minY = Math.min(minY, point.getY());
                maxY = Math.max(maxY, point.getY());
            }
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    private class BackgroundAction
    extends AbstractAction {
        public BackgroundAction() {
            super(ShapeDebugFrame.this.backgroundEnabled ? "Hide background" : "Show background");
            this.putValue("SwingSelectedKey", ShapeDebugFrame.this.backgroundEnabled);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean selected = (Boolean)this.getValue("SwingSelectedKey");
            ShapeDebugFrame.this.setBackgroundEnabled(!selected);
            this.putValue("SwingSelectedKey", ShapeDebugFrame.this.backgroundEnabled);
            this.putValue("Name", ShapeDebugFrame.this.backgroundEnabled ? "Hide background" : "Show background");
            ShapeDebugFrame.this.repaint();
        }
    }

    public static class Line2DShapeInfo
    extends ShapeInfo {
        private static final int SIZE = 2;
        private static final BasicStroke THICK_STROKE = new BasicStroke(6.0f, 0, 2);
        private static final BasicStroke THIN_STROKE = new BasicStroke(2.0f, 0, 2);
        private Collection<Line2D> lines;
        private Shape bounds;
        private boolean arrow;
        private boolean thick;
        private Color colour;

        public Line2DShapeInfo(Line2D line, String name, Color colour, boolean thick, boolean arrow) {
            this(Collections.singleton(line), name, colour, thick, arrow);
        }

        public Line2DShapeInfo(Collection<Line2D> lines, String name, Color colour, boolean thick, boolean arrow) {
            super(lines, name);
            this.lines = lines;
            this.arrow = arrow;
            this.thick = thick;
            this.colour = colour;
            if (lines.isEmpty()) {
                return;
            }
            if (lines.size() == 1) {
                Line2D l = lines.iterator().next();
                this.bounds = new Line2D.Double(l.getOrigin().getX(), l.getOrigin().getY(), l.getEndPoint().getX(), l.getEndPoint().getY());
            } else {
                double xMin = Double.POSITIVE_INFINITY;
                double yMin = Double.POSITIVE_INFINITY;
                double xMax = Double.NEGATIVE_INFINITY;
                double yMax = Double.NEGATIVE_INFINITY;
                for (Line2D line : lines) {
                    xMin = Math.min(xMin, line.getOrigin().getX());
                    xMax = Math.max(xMax, line.getOrigin().getX());
                    xMin = Math.min(xMin, line.getEndPoint().getX());
                    xMax = Math.max(xMax, line.getEndPoint().getX());
                    yMin = Math.min(yMin, line.getOrigin().getY());
                    yMax = Math.max(yMax, line.getOrigin().getY());
                    yMin = Math.min(yMin, line.getEndPoint().getY());
                    yMax = Math.max(yMax, line.getEndPoint().getY());
                }
                double xRange = xMax - xMin;
                double yRange = yMax - yMin;
                this.bounds = new Rectangle2D.Double(xMin, yMin, xMax - xMin, yMax - yMin);
                if (GeometryTools2D.nearlyZero(xRange) || GeometryTools2D.nearlyZero(yRange)) {
                    this.bounds = new Line2D.Double(xMin, yMin, xMax, yMax);
                }
            }
        }

        @Override
        public Shape paint(Graphics2D g, ScreenTransform transform) {
            if (this.lines.isEmpty()) {
                return null;
            }
            if (this.thick) {
                g.setStroke(THICK_STROKE);
            } else {
                g.setStroke(THIN_STROKE);
            }
            g.setColor(this.colour);
            Path2D.Double result = new Path2D.Double();
            for (Line2D line : this.lines) {
                rescuecore2.misc.geometry.Point2D start = line.getOrigin();
                rescuecore2.misc.geometry.Point2D end = line.getEndPoint();
                int x1 = transform.xToScreen(start.getX());
                int y1 = transform.yToScreen(start.getY());
                int x2 = transform.xToScreen(end.getX());
                int y2 = transform.yToScreen(end.getY());
                g.drawLine(x1, y1, x2, y2);
                if (this.arrow) {
                    DrawingTools.drawArrowHeads(x1, y1, x2, y2, g);
                }
                ((Path2D)result).moveTo(x1, y1);
                ((Path2D)result).lineTo(x2, y2);
            }
            return g.getStroke().createStrokedShape(result);
        }

        @Override
        public void paintLegend(Graphics2D g, int width, int height) {
            if (this.thick) {
                g.setStroke(THICK_STROKE);
            } else {
                g.setStroke(THIN_STROKE);
            }
            g.setColor(this.colour);
            g.drawLine(0, height / 2, width, height / 2);
            if (this.arrow) {
                DrawingTools.drawArrowHeads(0, height / 2, width, height / 2, g);
            }
        }

        @Override
        public Shape getBoundsShape() {
            return this.bounds;
        }

        @Override
        public Point2D getBoundsPoint() {
            return null;
        }
    }

    public static class Point2DShapeInfo
    extends ShapeInfo {
        private static final int SIZE = 3;
        private rescuecore2.misc.geometry.Point2D point;
        private Point2D boundsPoint;
        private boolean square;
        private Color colour;

        public Point2DShapeInfo(rescuecore2.misc.geometry.Point2D point, String name, Color colour, boolean square) {
            super(point, name);
            this.point = point;
            this.square = square;
            this.colour = colour;
            if (point != null) {
                this.boundsPoint = new Point2D.Double(point.getX(), point.getY());
            }
        }

        @Override
        public Shape paint(Graphics2D g, ScreenTransform transform) {
            if (this.point == null) {
                return null;
            }
            int x = transform.xToScreen(this.point.getX());
            int y = transform.yToScreen(this.point.getY());
            g.setColor(this.colour);
            if (this.square) {
                g.fillRect(x - 3, y - 3, 6, 6);
            } else {
                g.drawLine(x - 3, y - 3, x + 3, y + 3);
                g.drawLine(x - 3, y + 3, x + 3, y - 3);
            }
            return new Rectangle(x - 3, y - 3, 6, 6);
        }

        @Override
        public void paintLegend(Graphics2D g, int width, int height) {
            if (this.point == null) {
                return;
            }
            g.setColor(this.colour);
            int x = width / 2;
            int y = height / 2;
            if (this.square) {
                g.fillRect(x - 3, y - 3, 6, 6);
            } else {
                g.drawLine(x - 3, y - 3, x + 3, y + 3);
                g.drawLine(x - 3, y + 3, x + 3, y - 3);
            }
        }

        @Override
        public Shape getBoundsShape() {
            return null;
        }

        @Override
        public Point2D getBoundsPoint() {
            return this.boundsPoint;
        }
    }

    public static class AWTShapeInfo
    extends ShapeInfo {
        private Shape shape;
        private boolean fill;
        private Color colour;
        private Rectangle2D bounds;

        public AWTShapeInfo(Shape shape, String name, Color colour, boolean fill) {
            super(shape, name);
            this.shape = shape;
            this.fill = fill;
            this.colour = colour;
            if (shape != null) {
                this.bounds = shape.getBounds2D();
            }
        }

        @Override
        public Shape paint(Graphics2D g, ScreenTransform transform) {
            if (this.shape == null || this.shape instanceof Area && ((Area)this.shape).isEmpty()) {
                return null;
            }
            Path2D.Double path = new Path2D.Double();
            PathIterator pi = this.shape.getPathIterator(null);
            double[] d = new double[6];
            while (!pi.isDone()) {
                int type = pi.currentSegment(d);
                switch (type) {
                    case 0: {
                        ((Path2D)path).moveTo(transform.xToScreen(d[0]), transform.yToScreen(d[1]));
                        break;
                    }
                    case 1: {
                        ((Path2D)path).lineTo(transform.xToScreen(d[0]), transform.yToScreen(d[1]));
                        break;
                    }
                    case 4: {
                        path.closePath();
                        break;
                    }
                    case 2: {
                        ((Path2D)path).quadTo(transform.xToScreen(d[0]), transform.yToScreen(d[1]), transform.xToScreen(d[2]), transform.yToScreen(d[3]));
                        break;
                    }
                    case 3: {
                        ((Path2D)path).curveTo(transform.xToScreen(d[0]), transform.yToScreen(d[1]), transform.xToScreen(d[2]), transform.yToScreen(d[3]), transform.xToScreen(d[4]), transform.yToScreen(d[5]));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected PathIterator constant: " + type);
                    }
                }
                pi.next();
            }
            g.setColor(this.colour);
            if (this.fill) {
                g.fill(path);
            } else {
                g.draw(path);
            }
            return path.createTransformedShape(null);
        }

        @Override
        public void paintLegend(Graphics2D g, int width, int height) {
            if (this.shape == null) {
                return;
            }
            g.setColor(this.colour);
            if (this.fill) {
                g.fillRect(0, 0, width, height);
            } else {
                g.drawRect(0, 0, width - 1, height - 1);
            }
        }

        @Override
        public Rectangle2D getBoundsShape() {
            return this.bounds;
        }

        @Override
        public Point2D getBoundsPoint() {
            return null;
        }
    }

    public static abstract class ShapeInfo {
        protected String name;
        private Object object;

        protected ShapeInfo(Object object, String name) {
            this.object = object;
            this.name = name;
        }

        public abstract Shape paint(Graphics2D var1, ScreenTransform var2);

        public abstract void paintLegend(Graphics2D var1, int var2, int var3);

        public Object getObject() {
            return this.object;
        }

        public String getName() {
            return this.name;
        }

        public abstract Shape getBoundsShape();

        public abstract Point2D getBoundsPoint();
    }

    private class ShapeInfoLegend
    extends JComponent {
        private static final int ROW_OFFSET = 5;
        private static final int X_INDENT = 5;
        private static final int ENTRY_WIDTH = 50;
        private static final int ENTRY_HEIGHT = 9;
        private List<ShapeInfo> shapes = new ArrayList<ShapeInfo>();

        ShapeInfoLegend() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(500, 500);
        }

        @Override
        public void paintComponent(Graphics g) {
            String name;
            super.paintComponent(g);
            if (this.shapes.isEmpty()) {
                return;
            }
            HashSet<String> seen = new HashSet<String>();
            FontMetrics metrics = g.getFontMetrics();
            int height = metrics.getHeight();
            int y = this.getInsets().top;
            int x = this.getInsets().left + 5;
            if (ShapeDebugFrame.this.backgroundEnabled) {
                for (ShapeInfo next : ShapeDebugFrame.this.background) {
                    name = next.getName();
                    if (name == null || "".equals(name) || seen.contains(name)) continue;
                    seen.add(name);
                    next.paintLegend((Graphics2D)g.create(x, y + height / 2 - 4, 50, 9), 50, 9);
                    g.setColor(Color.black);
                    g.drawString(next.getName(), x + 50 + 5, y + metrics.getAscent());
                    y += height + 5;
                }
            }
            for (ShapeInfo next : this.shapes) {
                name = next.getName();
                if (name == null || "".equals(name) || seen.contains(name)) continue;
                seen.add(name);
                next.paintLegend((Graphics2D)g.create(x, y + height / 2 - 4, 50, 9), 50, 9);
                g.setColor(Color.black);
                g.drawString(next.getName(), x + 50 + 5, y + metrics.getAscent());
                y += height + 5;
            }
        }

        public void setShapes(Collection<ShapeInfo> s) {
            this.shapes.clear();
            this.shapes.addAll(s);
            this.repaint();
        }
    }

    private class ShapeViewer
    extends JComponent {
        private List<ShapeInfo> shapes;
        private ScreenTransform transform;
        private PanZoomListener panZoom = new PanZoomListener(this);
        private Map<Shape, ShapeInfo> drawnShapes = new HashMap<Shape, ShapeInfo>();

        public ShapeViewer() {
            this.shapes = new ArrayList<ShapeInfo>();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        Insets insets = ShapeViewer.this.getInsets();
                        Point p = new Point(e.getPoint());
                        p.translate(-insets.left, -insets.top);
                        List s = ShapeViewer.this.getShapesAtPoint(p);
                        for (ShapeInfo next : s) {
                            System.out.println(next.getObject());
                        }
                    }
                }
            });
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics g;
            Shape shape;
            boolean visible;
            super.paintComponent(graphics);
            this.drawnShapes.clear();
            if (this.shapes.isEmpty()) {
                return;
            }
            Insets insets = this.getInsets();
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            this.transform.rescale(width, height);
            for (ShapeInfo next : this.shapes) {
                visible = this.transform.isInView(next.getBoundsShape()) || this.transform.isInView(next.getBoundsPoint());
                if (!visible || (shape = next.paint((Graphics2D)(g = graphics.create(insets.left, insets.top, width, height)), this.transform)) == null) continue;
                this.drawnShapes.put(shape, next);
            }
            if (ShapeDebugFrame.this.backgroundEnabled) {
                for (ShapeInfo next : ShapeDebugFrame.this.background) {
                    visible = this.transform.isInView(next.getBoundsShape()) || this.transform.isInView(next.getBoundsPoint());
                    if (!visible || (shape = next.paint((Graphics2D)(g = graphics.create(insets.left, insets.top, width, height)), this.transform)) == null) continue;
                    this.drawnShapes.put(shape, next);
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(500, 500);
        }

        public void setShapes(Collection<ShapeInfo> s) {
            this.shapes.clear();
            this.shapes.addAll(s);
            Rectangle2D bounds = ShapeDebugFrame.this.getBounds(new Collection[]{this.shapes, ShapeDebugFrame.this.backgroundEnabled ? ShapeDebugFrame.this.background : null});
            this.transform = new ScreenTransform(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY());
            this.panZoom.setScreenTransform(this.transform);
            this.repaint();
        }

        public void zoomTo(Collection<ShapeInfo> zoom) {
            Rectangle2D bounds = ShapeDebugFrame.this.getBounds(new Collection[]{zoom});
            double newX = bounds.getMinX() - bounds.getWidth() * 0.1;
            double newY = bounds.getMinY() - bounds.getHeight() * 0.1;
            double newWidth = bounds.getWidth() * 1.2;
            double newHeight = bounds.getHeight() * 1.2;
            bounds.setRect(newX, newY, newWidth, newHeight);
            this.transform.show(bounds);
            this.repaint();
        }

        private List<ShapeInfo> getShapesAtPoint(Point p) {
            ArrayList<ShapeInfo> result = new ArrayList<ShapeInfo>();
            for (Map.Entry<Shape, ShapeInfo> next : this.drawnShapes.entrySet()) {
                Shape shape = next.getKey();
                if (!shape.contains(p)) continue;
                result.add(next.getValue());
            }
            return result;
        }
    }
}

