/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import rescuecore2.worldmodel.AbstractWorldModel;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;

public class DefaultWorldModel<T extends Entity>
extends AbstractWorldModel<T> {
    private Map<EntityID, T> entities = new HashMap<EntityID, T>();

    public DefaultWorldModel(Class<? extends T> clazz) {
        this.registerAllowedClass(clazz);
    }

    public static DefaultWorldModel<Entity> create() {
        return new DefaultWorldModel<Entity>(Entity.class);
    }

    @Override
    public final Collection<T> getAllEntities() {
        return Collections.unmodifiableCollection(this.entities.values());
    }

    @Override
    public final void addEntityImpl(T e) {
        this.entities.put(e.getID(), e);
        this.fireEntityAdded(e);
    }

    @Override
    public final void removeEntity(EntityID id) {
        Entity removed = (Entity)this.entities.remove(id);
        if (removed != null) {
            this.fireEntityRemoved(removed);
        }
    }

    @Override
    public final void removeAllEntities() {
        HashSet<T> all = new HashSet<T>(this.entities.values());
        this.entities.clear();
        for (Entity next : all) {
            this.fireEntityRemoved(next);
        }
    }

    @Override
    public final T getEntity(EntityID id) {
        return (T)((Entity)this.entities.get(id));
    }

    @Override
    public final Iterator<T> iterator() {
        return this.entities.values().iterator();
    }
}

