/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rescuecore2.log.Logger;
import rescuecore2.standard.components.StandardAgent;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.Refuge;
import rescuecore2.standard.entities.Road;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.kernel.comms.ChannelCommunicationModel;
import rescuecore2.standard.kernel.comms.StandardCommunicationModel;
import rescuecore2.worldmodel.EntityID;
import sample.SampleSearch;

public abstract class AbstractSampleAgent<E extends StandardEntity>
extends StandardAgent<E> {
    private static final int RANDOM_WALK_LENGTH = 50;
    private static final String SAY_COMMUNICATION_MODEL = StandardCommunicationModel.class.getName();
    private static final String SPEAK_COMMUNICATION_MODEL = ChannelCommunicationModel.class.getName();
    protected SampleSearch search;
    protected boolean useSpeak;
    protected List<EntityID> buildingIDs;
    protected List<EntityID> roadIDs;
    protected List<EntityID> refugeIDs;
    private Map<EntityID, Set<EntityID>> neighbours;

    protected AbstractSampleAgent() {
    }

    protected void postConnect() {
        super.postConnect();
        this.buildingIDs = new ArrayList<EntityID>();
        this.roadIDs = new ArrayList<EntityID>();
        this.refugeIDs = new ArrayList<EntityID>();
        for (StandardEntity next : (StandardWorldModel)this.model) {
            if (next instanceof Building) {
                this.buildingIDs.add(next.getID());
            }
            if (next instanceof Road) {
                this.roadIDs.add(next.getID());
            }
            if (!(next instanceof Refuge)) continue;
            this.refugeIDs.add(next.getID());
        }
        this.search = new SampleSearch((StandardWorldModel)this.model);
        this.neighbours = this.search.getGraph();
        this.useSpeak = this.config.getValue("kernel.communication-model").equals(SPEAK_COMMUNICATION_MODEL);
        Logger.debug((String)("Communcation model: " + this.config.getValue("kernel.communication-model")));
        Logger.debug((String)(this.useSpeak ? "Using speak model" : "Using say model"));
    }

    protected List<EntityID> randomWalk() {
        ArrayList<EntityID> result = new ArrayList<EntityID>(50);
        HashSet<EntityID> seen = new HashSet<EntityID>();
        EntityID current = ((Human)this.me()).getPosition();
        for (int i = 0; i < 50; ++i) {
            result.add(current);
            seen.add(current);
            ArrayList possible = new ArrayList(this.neighbours.get(current));
            Collections.shuffle(possible, this.random);
            boolean found = false;
            for (EntityID next : possible) {
                if (seen.contains(next)) continue;
                current = next;
                found = true;
                break;
            }
            if (!found) break;
        }
        return result;
    }
}

