/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.misc.Handy;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.Refuge;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.EntityID;
import sample.AbstractSampleAgent;
import sample.DistanceSorter;

public class SampleFireBrigade
extends AbstractSampleAgent<FireBrigade> {
    private static final String MAX_WATER_KEY = "fire.tank.maximum";
    private static final String MAX_DISTANCE_KEY = "fire.extinguish.max-distance";
    private static final String MAX_POWER_KEY = "fire.extinguish.max-sum";
    private int maxWater;
    private int maxDistance;
    private int maxPower;

    public String toString() {
        return "Sample fire brigade";
    }

    @Override
    protected void postConnect() {
        super.postConnect();
        ((StandardWorldModel)this.model).indexClass(new StandardEntityURN[]{StandardEntityURN.BUILDING, StandardEntityURN.REFUGE});
        this.maxWater = this.config.getIntValue(MAX_WATER_KEY);
        this.maxDistance = this.config.getIntValue(MAX_DISTANCE_KEY);
        this.maxPower = this.config.getIntValue(MAX_POWER_KEY);
        Logger.info((String)("Sample fire brigade connected: max extinguish distance = " + this.maxDistance + ", max power = " + this.maxPower + ", max tank = " + this.maxWater));
    }

    protected void think(int time, ChangeSet changed, Collection<Command> heard) {
        if (time == this.config.getIntValue("kernel.agents.ignoreuntil")) {
            this.sendSubscribe(time, new int[]{1});
        }
        for (Command next : heard) {
            Logger.debug((String)("Heard " + next));
        }
        FireBrigade me = (FireBrigade)this.me();
        if (me.isWaterDefined() && me.getWater() < this.maxWater && this.location() instanceof Refuge) {
            Logger.info((String)("Filling with water at " + this.location()));
            this.sendRest(time);
            return;
        }
        if (me.isWaterDefined() && me.getWater() == 0) {
            List<EntityID> path = this.search.breadthFirstSearch(((FireBrigade)this.me()).getPosition(), this.refugeIDs);
            if (path != null) {
                Logger.info((String)"Moving to refuge");
                this.sendMove(time, path);
                return;
            }
            Logger.debug((String)"Couldn't plan a path to a refuge.");
            path = this.randomWalk();
            Logger.info((String)"Moving randomly");
            this.sendMove(time, path);
            return;
        }
        Collection<EntityID> all = this.getBurningBuildings();
        for (EntityID next : all) {
            if (((StandardWorldModel)this.model).getDistance(this.getID(), next) > this.maxDistance) continue;
            Logger.info((String)("Extinguishing " + next));
            this.sendExtinguish(time, next, this.maxPower);
            this.sendSpeak(time, 1, ("Extinguishing " + next).getBytes());
            return;
        }
        for (EntityID next : all) {
            List<EntityID> path = this.planPathToFire(next);
            if (path == null) continue;
            Logger.info((String)"Moving to target");
            this.sendMove(time, path);
            return;
        }
        List<EntityID> path = null;
        Logger.debug((String)"Couldn't plan a path to a fire.");
        path = this.randomWalk();
        Logger.info((String)"Moving randomly");
        this.sendMove(time, path);
    }

    protected EnumSet<StandardEntityURN> getRequestedEntityURNsEnum() {
        return EnumSet.of(StandardEntityURN.FIRE_BRIGADE);
    }

    private Collection<EntityID> getBurningBuildings() {
        Collection e = ((StandardWorldModel)this.model).getEntitiesOfType(StandardEntityURN.BUILDING);
        ArrayList<Building> result = new ArrayList<Building>();
        for (StandardEntity next : e) {
            Building b;
            if (!(next instanceof Building) || !(b = (Building)next).isOnFire()) continue;
            result.add(b);
        }
        Collections.sort(result, new DistanceSorter(this.location(), (StandardWorldModel)this.model));
        return Handy.objectsToIDs(result);
    }

    private List<EntityID> planPathToFire(EntityID target) {
        Collection targets = ((StandardWorldModel)this.model).getObjectsInRange(target, this.maxDistance);
        if (targets.isEmpty()) {
            return null;
        }
        return this.search.breadthFirstSearch(((FireBrigade)this.me()).getPosition(), Handy.objectsToIDs((Collection)targets));
    }
}

