/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.commands;

import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.commands.Command;

public class KAHear
extends Command {
    private int toID;
    private int fromID;
    private int length;
    private byte[] msg;
    private byte channel;

    public KAHear(int to, int from, int length, byte[] data, byte channel) {
        super(69);
        this.toID = to;
        this.fromID = from;
        this.length = length;
        this.msg = new byte[length];
        System.arraycopy(data, 0, this.msg, 0, length);
        this.channel = channel;
    }

    public KAHear(InputBuffer in) {
        super(69);
        this.read(in);
    }

    @Override
    public void read(InputBuffer in) {
        this.toID = in.readInt();
        this.fromID = in.readInt();
        this.channel = (byte)in.readInt();
        this.length = in.readInt();
        this.msg = new byte[this.length];
        in.readBytes(this.msg);
    }

    @Override
    public void write(OutputBuffer out) {
        out.writeInt(this.toID);
        out.writeInt(this.fromID);
        out.writeInt(this.channel);
        out.writeInt(this.length);
        out.writeBytes(this.msg);
    }

    public int getToID() {
        return this.toID;
    }

    public int getFromID() {
        return this.fromID;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.msg;
    }

    public byte getChannel() {
        return this.channel;
    }

    @Override
    public String toString() {
        return super.toString() + " from " + this.fromID + " to " + this.toID + ": " + this.length + " bytes on channel " + this.channel;
    }
}

