/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.debug;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rescuecore.debug.DebugEntry;

public class DebugLog {
    private static final Collection<DebugEntry> NO_ENTRIES = Collections.emptySet();
    private Map<String, List<List<DebugEntry>>> nameToEntries = new HashMap<String, List<List<DebugEntry>>>();
    private int maxTimestep = 0;

    public DebugLog(String fileName) throws IOException, ClassNotFoundException {
        this(new File(fileName));
    }

    public DebugLog(File file) throws IOException, ClassNotFoundException {
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            while (true) {
                String name = in.readUTF();
                DebugEntry next = (DebugEntry)in.readObject();
                System.out.println(next);
                this.addEntry(name, next);
                this.maxTimestep = Math.max(this.maxTimestep, next.getTimestep());
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public Collection<String> getAllNames() {
        return this.nameToEntries.keySet();
    }

    public int getMaxTimestep(String name) {
        List<List<DebugEntry>> listOfLists = this.nameToEntries.get(name);
        if (listOfLists == null) {
            return -1;
        }
        return listOfLists.size() - 1;
    }

    public int getMaxTimestep() {
        return this.maxTimestep;
    }

    public Collection<DebugEntry> getEntriesForTime(String name, int time) {
        List<List<DebugEntry>> listOfLists = this.nameToEntries.get(name);
        if (listOfLists == null) {
            return NO_ENTRIES;
        }
        if (time >= listOfLists.size()) {
            return NO_ENTRIES;
        }
        List<DebugEntry> result = listOfLists.get(time);
        if (result == null) {
            return NO_ENTRIES;
        }
        return Collections.unmodifiableCollection(result);
    }

    private void addEntry(String name, DebugEntry next) {
        List<List<DebugEntry>> listOfLists = this.nameToEntries.get(name);
        if (listOfLists == null) {
            listOfLists = new ArrayList<List<DebugEntry>>();
            this.nameToEntries.put(name, listOfLists);
        }
        int time = next.getTimestep();
        while (time >= listOfLists.size()) {
            listOfLists.add(new ArrayList());
        }
        List<DebugEntry> thisList = listOfLists.get(time);
        thisList.add(next);
    }
}

