/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.event;

import rescuecore.RescueObject;
import rescuecore.event.MemoryListener;
import rescuecore.event.ObjectAddedEvent;
import rescuecore.event.ObjectChangedEvent;

public class FilterMemoryListener
implements MemoryListener {
    private int mode;
    private Class clazz;
    private int type;
    private MemoryListener listener;
    public static final int MODE_CLASS = 0;
    public static final int MODE_TYPE = 1;

    private FilterMemoryListener(int mode, Class clazz, int type, MemoryListener l) {
        this.mode = mode;
        this.clazz = clazz;
        this.type = type;
        this.listener = l;
    }

    public static MemoryListener createClassFilter(Class clazz, MemoryListener l) {
        return new FilterMemoryListener(0, clazz, 0, l);
    }

    public static MemoryListener createTypeFilter(int type, MemoryListener l) {
        return new FilterMemoryListener(1, null, type, l);
    }

    @Override
    public void objectAdded(ObjectAddedEvent event) {
        if (this.filter(event.getObject())) {
            this.listener.objectAdded(event);
        }
    }

    @Override
    public void objectChanged(ObjectChangedEvent event) {
        if (this.filter(event.getObject())) {
            this.listener.objectChanged(event);
        }
    }

    private boolean filter(RescueObject o) {
        switch (this.mode) {
            case 0: {
                return this.clazz.isInstance(o);
            }
            case 1: {
                return o.getType() == this.type;
            }
        }
        return false;
    }
}

