/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.Scenario;
import gis2.ScenarioException;
import gis2.scenario.AgentOverlay;
import gis2.scenario.CancelledByUserException;
import gis2.scenario.ClearAgentsFunction;
import gis2.scenario.ClearAllFunction;
import gis2.scenario.ClearFiresFunction;
import gis2.scenario.Function;
import gis2.scenario.PlaceAgentsFunction;
import gis2.scenario.PlaceAmbulanceCentreTool;
import gis2.scenario.PlaceAmbulanceTeamTool;
import gis2.scenario.PlaceCivilianTool;
import gis2.scenario.PlaceFireBrigadeTool;
import gis2.scenario.PlaceFireStationTool;
import gis2.scenario.PlaceFireTool;
import gis2.scenario.PlacePoliceForceTool;
import gis2.scenario.PlacePoliceOfficeTool;
import gis2.scenario.PlaceRefugeTool;
import gis2.scenario.RandomiseFunction;
import gis2.scenario.RemoveAmbulanceCentreTool;
import gis2.scenario.RemoveAmbulanceTeamTool;
import gis2.scenario.RemoveCivilianTool;
import gis2.scenario.RemoveFireBrigadeTool;
import gis2.scenario.RemoveFireStationTool;
import gis2.scenario.RemoveFireTool;
import gis2.scenario.RemovePoliceForceTool;
import gis2.scenario.RemovePoliceOfficeTool;
import gis2.scenario.RemoveRefugeTool;
import gis2.scenario.Tool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import maps.MapException;
import maps.MapReader;
import maps.gml.GMLBuilding;
import maps.gml.GMLMap;
import maps.gml.view.BuildingDecorator;
import maps.gml.view.DecoratorOverlay;
import maps.gml.view.FilledShapeDecorator;
import maps.gml.view.GMLMapViewer;
import maps.gml.view.GMLObjectInspector;
import maps.gml.view.Overlay;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import rescuecore2.log.Logger;

public class ScenarioEditor
extends JPanel {
    private static final int VIEWER_PREFERRED_SIZE = 500;
    private static final int INSPECTOR_PREFERRED_WIDTH = 300;
    private static final int INSPECTOR_PREFERRED_HEIGHT = 500;
    private static final NumberFormat FORMAT = new DecimalFormat("#0.000");
    private static final Color FIRE_COLOUR = new Color(255, 0, 0, 128);
    private static final Color FIRE_STATION_COLOUR = new Color(255, 255, 0);
    private static final Color POLICE_OFFICE_COLOUR = new Color(0, 0, 255);
    private static final Color AMBULANCE_CENTRE_COLOUR = new Color(255, 255, 255);
    private static final Color REFUGE_COLOUR = new Color(0, 128, 0);
    private GMLMap map;
    private GMLMapViewer viewer;
    private GMLObjectInspector inspector;
    private DecoratorOverlay fireOverlay;
    private DecoratorOverlay centreOverlay;
    private AgentOverlay agentOverlay;
    private Scenario scenario;
    private Tool currentTool;
    private JLabel statusLabel;
    private boolean changed;
    private UndoManager undoManager;
    private Action undoAction;
    private Action redoAction;
    private File baseDir;
    private File saveFile;
    private FilledShapeDecorator fireDecorator = new FilledShapeDecorator(FIRE_COLOUR, null, null);
    private FilledShapeDecorator fireStationDecorator = new FilledShapeDecorator(FIRE_STATION_COLOUR, null, null);
    private FilledShapeDecorator policeOfficeDecorator = new FilledShapeDecorator(POLICE_OFFICE_COLOUR, null, null);
    private FilledShapeDecorator ambulanceCentreDecorator = new FilledShapeDecorator(AMBULANCE_CENTRE_COLOUR, null, null);
    private FilledShapeDecorator refugeDecorator = new FilledShapeDecorator(REFUGE_COLOUR, null, null);

    public ScenarioEditor(JMenuBar menuBar) {
        this(menuBar, null, null);
    }

    public ScenarioEditor(JMenuBar menuBar, GMLMap map, Scenario scenario) {
        super(new BorderLayout());
        this.map = map;
        this.scenario = scenario;
        this.viewer = new GMLMapViewer(map);
        this.statusLabel = new JLabel("Status");
        this.fireOverlay = new DecoratorOverlay();
        this.centreOverlay = new DecoratorOverlay();
        this.agentOverlay = new AgentOverlay(this);
        this.viewer.addOverlay((Overlay)this.fireOverlay);
        this.viewer.addOverlay((Overlay)this.centreOverlay);
        this.viewer.addOverlay((Overlay)this.agentOverlay);
        this.inspector = new GMLObjectInspector(map);
        this.undoManager = new UndoManager();
        this.viewer.setPreferredSize(new Dimension(500, 500));
        this.inspector.setPreferredSize(new Dimension(300, 500));
        this.viewer.setBackground(Color.GRAY);
        this.viewer.getPanZoomListener().setPanOnRightMouse();
        this.changed = false;
        JToolBar fileToolbar = new JToolBar("File");
        JToolBar editToolbar = new JToolBar("Edit");
        JToolBar toolsToolbar = new JToolBar("Tools");
        JToolBar functionsToolbar = new JToolBar("Functions");
        JMenu fileMenu = new JMenu("File", false);
        JMenu editMenu = new JMenu("Edit", false);
        JMenu toolsMenu = new JMenu("Tools", false);
        JMenu functionsMenu = new JMenu("Functions", false);
        this.createFileActions(fileMenu, fileToolbar);
        this.createEditActions(editMenu, editToolbar);
        this.createToolActions(toolsMenu, toolsToolbar);
        this.createFunctionActions(functionsMenu, functionsToolbar);
        JSplitPane split = new JSplitPane(1, (Component)this.viewer, (Component)this.inspector);
        this.add((Component)split, "Center");
        JPanel toolbars = new JPanel(new GridLayout(0, 1));
        toolbars.add(fileToolbar);
        toolbars.add(editToolbar);
        toolbars.add(toolsToolbar);
        toolbars.add(functionsToolbar);
        this.add((Component)toolbars, "North");
        this.add((Component)this.statusLabel, "South");
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(toolsMenu);
        menuBar.add(functionsMenu);
        this.baseDir = new File(System.getProperty("user.dir"));
        this.saveFile = null;
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Scenario Editor");
        JMenuBar menuBar = new JMenuBar();
        final ScenarioEditor editor = new ScenarioEditor(menuBar);
        if (args.length > 0 && args[0].length() > 0) {
            try {
                editor.load(args[0]);
            }
            catch (CancelledByUserException e) {
                return;
            }
            catch (MapException e) {
                e.printStackTrace();
            }
            catch (ScenarioException e) {
                e.printStackTrace();
            }
        }
        frame.setJMenuBar(menuBar);
        frame.setContentPane(editor);
        frame.setDefaultCloseOperation(0);
        frame.pack();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    editor.close();
                    frame.setVisible(false);
                    frame.dispose();
                    System.exit(0);
                }
                catch (CancelledByUserException ex) {
                    frame.setVisible(true);
                }
            }
        });
        frame.setVisible(true);
    }

    public void load() throws CancelledByUserException, MapException, ScenarioException {
        JFileChooser chooser = new JFileChooser(this.baseDir);
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Directories";
            }
        });
        if (chooser.showOpenDialog(this) == 0) {
            this.load(chooser.getSelectedFile());
        }
    }

    public void load(String filename) throws CancelledByUserException, MapException, ScenarioException {
        this.load(new File(filename));
    }

    public void load(File dir) throws CancelledByUserException, MapException, ScenarioException {
        InputStreamReader r = null;
        try {
            GMLMap newMap = (GMLMap)MapReader.readMap((File)new File(dir, "map.gml"));
            File f = new File(dir, "scenario.xml");
            SAXReader saxReader = new SAXReader();
            r = new FileReader(f);
            Document doc = saxReader.read((Reader)r);
            Scenario newScenario = new Scenario(doc);
            this.setScenario(newMap, newScenario);
            this.baseDir = dir;
            this.saveFile = f;
        }
        catch (IOException e) {
            throw new ScenarioException(e);
        }
        catch (DocumentException e) {
            throw new ScenarioException(e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {
                    throw new ScenarioException(e);
                }
            }
        }
    }

    public void setScenario(GMLMap newMap, Scenario newScenario) throws CancelledByUserException {
        this.checkForChanges();
        if (!this.checkScenario(newMap, newScenario)) {
            JOptionPane.showMessageDialog(null, "The scenario file contained errors.");
            return;
        }
        this.map = newMap;
        this.scenario = newScenario;
        this.changed = false;
        this.viewer.setMap(this.map);
        this.inspector.setMap(this.map);
        this.updateOverlays();
    }

    public GMLMap getMap() {
        return this.map;
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public void save() throws ScenarioException {
        if (this.saveFile == null) {
            this.saveAs();
        }
        if (this.saveFile != null) {
            Logger.debug((String)("Saving to " + this.saveFile.getAbsolutePath()));
            Document doc = DocumentHelper.createDocument();
            this.scenario.write(doc);
            try {
                if (!this.saveFile.exists()) {
                    File parent = this.saveFile.getParentFile();
                    if (!parent.exists() && !this.saveFile.getParentFile().mkdirs()) {
                        throw new ScenarioException("Couldn't create file " + this.saveFile.getPath());
                    }
                    if (!this.saveFile.createNewFile()) {
                        throw new ScenarioException("Couldn't create file " + this.saveFile.getPath());
                    }
                }
                XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(this.saveFile), OutputFormat.createPrettyPrint());
                writer.write(doc);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                throw new ScenarioException(e);
            }
            this.baseDir = this.saveFile.getParentFile();
            this.changed = false;
        }
    }

    public void saveAs() throws ScenarioException {
        JFileChooser chooser = new JFileChooser(this.baseDir);
        if (chooser.showSaveDialog(this) == 0) {
            this.saveFile = chooser.getSelectedFile();
            this.save();
        }
    }

    public void close() throws CancelledByUserException {
        this.checkForChanges();
    }

    public GMLMapViewer getViewer() {
        return this.viewer;
    }

    public GMLObjectInspector getInspector() {
        return this.inspector;
    }

    public void setChanged() {
        this.changed = true;
    }

    public void addEdit(UndoableEdit edit) {
        this.undoManager.addEdit(edit);
        this.undoAction.setEnabled(this.undoManager.canUndo());
        this.redoAction.setEnabled(this.undoManager.canRedo());
    }

    public void updateOverlays() {
        this.updateFireOverlay();
        this.updateCentreOverlay();
        this.updateAgentOverlay();
        this.updateStatusLabel();
        this.viewer.repaint();
    }

    private void checkForChanges() throws CancelledByUserException {
        if (this.changed) {
            switch (JOptionPane.showConfirmDialog(null, "The current scenario has changes. Do you want to save them?")) {
                case 0: {
                    try {
                        this.save();
                        break;
                    }
                    catch (ScenarioException e) {
                        JOptionPane.showMessageDialog(null, e);
                        throw new CancelledByUserException();
                    }
                }
                case 1: {
                    this.changed = false;
                    return;
                }
                case 2: {
                    throw new CancelledByUserException();
                }
                default: {
                    throw new RuntimeException("JOptionPane.showConfirmDialog returned something weird");
                }
            }
        }
    }

    private void createFileActions(JMenu menu, JToolBar toolbar) {
        AbstractAction newAction = new AbstractAction("New"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ScenarioEditor.this.checkForChanges();
                    ScenarioEditor.this.setScenario(ScenarioEditor.this.map, new Scenario());
                }
                catch (CancelledByUserException ex) {
                    return;
                }
            }
        };
        AbstractAction loadAction = new AbstractAction("Load"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ScenarioEditor.this.checkForChanges();
                    ScenarioEditor.this.load();
                }
                catch (CancelledByUserException ex) {
                    return;
                }
                catch (MapException ex) {
                    JOptionPane.showMessageDialog(null, (Object)ex);
                }
                catch (ScenarioException ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
            }
        };
        AbstractAction saveAction = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ScenarioEditor.this.save();
                }
                catch (ScenarioException ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
            }
        };
        AbstractAction saveAsAction = new AbstractAction("Save as"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ScenarioEditor.this.saveAs();
                }
                catch (ScenarioException ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
            }
        };
        toolbar.add(newAction);
        toolbar.add(loadAction);
        toolbar.add(saveAction);
        toolbar.add(saveAsAction);
        menu.add(newAction);
        menu.add(loadAction);
        menu.add(saveAction);
        menu.add(saveAsAction);
    }

    private void createEditActions(JMenu menu, JToolBar toolbar) {
        this.undoAction = new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ScenarioEditor.this.undoManager.undo();
                }
                catch (CannotUndoException ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
                this.setEnabled(ScenarioEditor.this.undoManager.canUndo());
                ScenarioEditor.this.redoAction.setEnabled(ScenarioEditor.this.undoManager.canRedo());
            }
        };
        this.redoAction = new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ScenarioEditor.this.undoManager.redo();
                }
                catch (CannotUndoException ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
                this.setEnabled(ScenarioEditor.this.undoManager.canRedo());
                ScenarioEditor.this.undoAction.setEnabled(ScenarioEditor.this.undoManager.canUndo());
            }
        };
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
        toolbar.add(this.undoAction);
        toolbar.add(this.redoAction);
        menu.add(this.undoAction);
        menu.add(this.redoAction);
    }

    private void createToolActions(JMenu menu, JToolBar toolbar) {
        ButtonGroup toolbarGroup = new ButtonGroup();
        ButtonGroup menuGroup = new ButtonGroup();
        menu.addSeparator();
        toolbar.addSeparator();
        this.addTool(new PlaceFireTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new RemoveFireTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new PlaceRefugeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new RemoveRefugeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new PlaceCivilianTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new RemoveCivilianTool(this), menu, toolbar, menuGroup, toolbarGroup);
        menu.addSeparator();
        toolbar.addSeparator();
        this.addTool(new PlaceFireBrigadeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new RemoveFireBrigadeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new PlacePoliceForceTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new RemovePoliceForceTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new PlaceAmbulanceTeamTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new RemoveAmbulanceTeamTool(this), menu, toolbar, menuGroup, toolbarGroup);
        menu.addSeparator();
        toolbar.addSeparator();
        this.addTool(new PlaceFireStationTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new RemoveFireStationTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new PlacePoliceOfficeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new RemovePoliceOfficeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new PlaceAmbulanceCentreTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new RemoveAmbulanceCentreTool(this), menu, toolbar, menuGroup, toolbarGroup);
    }

    private void createFunctionActions(JMenu menu, JToolBar toolbar) {
        this.addFunction(new RandomiseFunction(this), menu, toolbar);
        this.addFunction(new ClearFiresFunction(this), menu, toolbar);
        this.addFunction(new ClearAgentsFunction(this), menu, toolbar);
        this.addFunction(new ClearAllFunction(this), menu, toolbar);
        this.addFunction(new PlaceAgentsFunction(this), menu, toolbar);
    }

    private void addTool(final Tool t, JMenu menu, JToolBar toolbar, ButtonGroup menuGroup, ButtonGroup toolbarGroup) {
        final JToggleButton toggle = new JToggleButton();
        final JCheckBoxMenuItem check = new JCheckBoxMenuItem();
        AbstractAction action = new AbstractAction(t.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScenarioEditor.this.currentTool != null) {
                    ScenarioEditor.this.currentTool.deactivate();
                }
                ScenarioEditor.this.currentTool = t;
                toggle.setSelected(true);
                check.setSelected(true);
                ScenarioEditor.this.currentTool.activate();
            }
        };
        toggle.setAction(action);
        check.setAction(action);
        menu.add(check);
        toolbar.add(toggle);
        menuGroup.add(check);
        toolbarGroup.add(toggle);
    }

    private void addFunction(final Function f, JMenu menu, JToolBar toolbar) {
        AbstractAction action = new AbstractAction(f.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                f.execute();
            }
        };
        toolbar.add(action);
        menu.add(action);
    }

    private boolean checkScenario(GMLMap newMap, Scenario newScenario) {
        boolean valid = true;
        for (int id : newScenario.getFires()) {
            if (newMap.getBuilding(id) != null) continue;
            valid = false;
            Logger.warn((String)("Fire at non-existing building " + id));
        }
        for (int id : newScenario.getRefuges()) {
            if (newMap.getBuilding(id) != null) continue;
            valid = false;
            Logger.warn((String)("Refuge at non-existing building " + id));
        }
        for (int id : newScenario.getFireStations()) {
            if (newMap.getBuilding(id) != null) continue;
            valid = false;
            Logger.warn((String)("Fire station at non-existing building " + id));
        }
        for (int id : newScenario.getAmbulanceCentres()) {
            if (newMap.getBuilding(id) != null) continue;
            valid = false;
            Logger.warn((String)("Ambulance centre at non-existing building " + id));
        }
        for (int id : newScenario.getPoliceOffices()) {
            if (newMap.getBuilding(id) != null) continue;
            valid = false;
            Logger.warn((String)("Police office at non-existing building " + id));
        }
        for (int id : newScenario.getCivilians()) {
            if (newMap.getShape(id) != null) continue;
            valid = false;
            Logger.warn((String)("Civilian at non-existing shape " + id));
        }
        for (int id : newScenario.getFireBrigades()) {
            if (newMap.getShape(id) != null) continue;
            valid = false;
            Logger.warn((String)("Fire brigade at non-existing shape " + id));
        }
        for (int id : newScenario.getAmbulanceTeams()) {
            if (newMap.getShape(id) != null) continue;
            valid = false;
            Logger.warn((String)("Ambulance team at non-existing shape " + id));
        }
        for (int id : newScenario.getPoliceForces()) {
            if (newMap.getShape(id) != null) continue;
            valid = false;
            Logger.warn((String)("Police force at non-existing shape " + id));
        }
        return valid;
    }

    private void updateStatusLabel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScenarioEditor.this.statusLabel.setText(ScenarioEditor.this.scenario.getFires().size() + " fires, " + ScenarioEditor.this.scenario.getRefuges().size() + " refuges, " + ScenarioEditor.this.scenario.getCivilians().size() + " civilians, " + ScenarioEditor.this.scenario.getFireBrigades().size() + " fb, " + ScenarioEditor.this.scenario.getFireStations().size() + " fs, " + ScenarioEditor.this.scenario.getPoliceForces().size() + " pf, " + ScenarioEditor.this.scenario.getPoliceOffices().size() + " po, " + ScenarioEditor.this.scenario.getAmbulanceTeams().size() + " at, " + ScenarioEditor.this.scenario.getAmbulanceCentres().size() + " ac");
            }
        });
    }

    private void updateFireOverlay() {
        this.fireOverlay.clearAllBuildingDecorators();
        for (int next : this.scenario.getFires()) {
            this.fireOverlay.setBuildingDecorator((BuildingDecorator)this.fireDecorator, new GMLBuilding[]{this.map.getBuilding(next)});
        }
    }

    private void updateCentreOverlay() {
        this.centreOverlay.clearAllBuildingDecorators();
        for (int next : this.scenario.getFireStations()) {
            this.centreOverlay.setBuildingDecorator((BuildingDecorator)this.fireStationDecorator, new GMLBuilding[]{this.map.getBuilding(next)});
        }
        for (int next : this.scenario.getPoliceOffices()) {
            this.centreOverlay.setBuildingDecorator((BuildingDecorator)this.policeOfficeDecorator, new GMLBuilding[]{this.map.getBuilding(next)});
        }
        for (int next : this.scenario.getAmbulanceCentres()) {
            this.centreOverlay.setBuildingDecorator((BuildingDecorator)this.ambulanceCentreDecorator, new GMLBuilding[]{this.map.getBuilding(next)});
        }
        for (int next : this.scenario.getRefuges()) {
            this.centreOverlay.setBuildingDecorator((BuildingDecorator)this.refugeDecorator, new GMLBuilding[]{this.map.getBuilding(next)});
        }
    }

    private void updateAgentOverlay() {
    }
}

