/*
 * Decompiled with CFR 0.152.
 */
package maps.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import maps.gml.GMLBuilding;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLMap;
import maps.gml.GMLRoad;
import maps.gml.GMLShape;
import maps.validate.MapValidator;
import maps.validate.ValidationError;

public class GMLConnectivityValidator
implements MapValidator<GMLMap> {
    private GMLMap map = null;

    @Override
    public Collection<ValidationError> validate(GMLMap mmap) {
        this.map = mmap;
        LinkedList<ValidationError> errors = new LinkedList<ValidationError>();
        HashSet<GMLShape> toBeChecked = new HashSet<GMLShape>();
        for (GMLShape shape : this.map.getAllShapes()) {
            errors.addAll(this.validateShape(shape));
            if (!(shape instanceof GMLBuilding) && !(shape instanceof GMLRoad)) continue;
            toBeChecked.add(shape);
        }
        LinkedList<GMLShape> open = new LinkedList<GMLShape>();
        GMLShape first = (GMLShape)toBeChecked.iterator().next();
        open.add(first);
        while (!open.isEmpty()) {
            GMLShape next = (GMLShape)open.remove();
            toBeChecked.remove(next);
            for (GMLShape n : this.getNeigbours(next)) {
                if (toBeChecked.contains(n)) {
                    open.add(n);
                }
                if (n instanceof GMLBuilding || n instanceof GMLRoad) continue;
                String message = "Can reach non-building, non-road shape " + n.getID();
                errors.add(new ValidationError(next.getID(), message));
            }
        }
        if (!toBeChecked.isEmpty()) {
            for (GMLShape unreachable : toBeChecked) {
                String message = "The map is not fully connected. Shape cannot be reached from " + first.getID();
                errors.add(new ValidationError(unreachable.getID(), message));
            }
        }
        return errors;
    }

    private Collection<ValidationError> validateShape(GMLShape shape) {
        LinkedList<ValidationError> errors = new LinkedList<ValidationError>();
        for (GMLDirectedEdge e : shape.getEdges()) {
            String message;
            if (!shape.hasNeighbour(e)) continue;
            int nId = shape.getNeighbour(e);
            GMLShape neighbour = this.map.getShape(nId);
            if (neighbour == null) {
                message = "Connection to nonexisting id " + nId + " via Edge " + e.getEdge().getID();
                errors.add(new ValidationError(shape.getID(), message));
                continue;
            }
            if (neighbour == shape) {
                message = "Shape is connected to itself via Edge" + e.getEdge().getID();
                errors.add(new ValidationError(shape.getID(), message));
                continue;
            }
            GMLShape backRef = null;
            try {
                if (neighbour.hasNeighbour(e.getEdge())) {
                    backRef = this.map.getShape(neighbour.getNeighbour(e.getEdge()));
                }
                if (backRef == shape) continue;
                String message2 = "Connection to " + neighbour.getID() + " via Edge " + e.getEdge().getID() + " is not reflexive.";
                errors.add(new ValidationError(shape.getID(), message2));
            }
            catch (IllegalArgumentException ex) {
                String message3 = "Neigbour " + neighbour.getID() + " does not share Edge " + e.getEdge().getID();
                errors.add(new ValidationError(shape.getID(), message3));
            }
        }
        return errors;
    }

    private Collection<GMLShape> getNeigbours(GMLShape shape) {
        ArrayList<GMLShape> result = new ArrayList<GMLShape>();
        for (GMLDirectedEdge edge : shape.getEdges()) {
            GMLShape n;
            if (!shape.hasNeighbour(edge) || (n = this.map.getShape(shape.getNeighbour(edge))) == null) continue;
            result.add(n);
        }
        return result;
    }
}

