/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.legacy2gml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import maps.convert.legacy2gml.RoadInfo;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLRoad;
import maps.legacy.LegacyMap;
import maps.legacy.LegacyNode;
import maps.legacy.LegacyRoad;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.Vector2D;

public class NodeInfo {
    private LegacyNode node;
    private Point2D centre;
    private List<GMLNode> apexes;
    private GMLRoad road;

    public NodeInfo(LegacyNode node) {
        this.node = node;
        this.centre = new Point2D((double)node.getX(), (double)node.getY());
    }

    public LegacyNode getNode() {
        return this.node;
    }

    public Point2D getLocation() {
        return this.centre;
    }

    public GMLRoad getRoad() {
        return this.road;
    }

    public void process(LegacyMap legacy, GMLMap gml, Map<Integer, RoadInfo> roadInfo) {
        this.apexes = new ArrayList<GMLNode>();
        ArrayList<RoadAspect> roads = new ArrayList<RoadAspect>();
        for (int id : this.node.getEdges()) {
            LegacyRoad lRoad = legacy.getRoad(id);
            if (lRoad == null) continue;
            roads.add(new RoadAspect(lRoad, this.node, legacy, roadInfo.get(id)));
        }
        if (roads.size() == 1) {
            RoadAspect aspect = (RoadAspect)roads.get(0);
            this.findRoadEdges(aspect, this.centre);
        } else {
            Point2D apex;
            RoadAspect first;
            CounterClockwiseSort sort = new CounterClockwiseSort(this.centre);
            Collections.sort(roads, sort);
            Iterator it = roads.iterator();
            RoadAspect prev = first = (RoadAspect)it.next();
            while (it.hasNext()) {
                RoadAspect next = (RoadAspect)it.next();
                apex = this.findIncomingRoadIntersection(prev, next, this.centre);
                this.apexes.add(gml.createNode(apex.getX(), apex.getY()));
                prev = next;
            }
            apex = this.findIncomingRoadIntersection(prev, first, this.centre);
            this.apexes.add(gml.createNode(apex.getX(), apex.getY()));
        }
        if (this.apexes.size() > 2) {
            this.road = gml.createRoadFromNodes(this.apexes);
        }
    }

    private Point2D findIncomingRoadIntersection(RoadAspect first, RoadAspect second, Point2D centrePoint) {
        Point2D start2Point;
        Line2D line2;
        LegacyNode firstNode = first.getFarNode();
        LegacyNode secondNode = second.getFarNode();
        Point2D firstPoint = new Point2D((double)firstNode.getX(), (double)firstNode.getY());
        Point2D secondPoint = new Point2D((double)secondNode.getX(), (double)secondNode.getY());
        Vector2D firstVector = centrePoint.minus(firstPoint);
        Vector2D secondVector = centrePoint.minus(secondPoint);
        Vector2D firstNormal = firstVector.getNormal().normalised().scale((double)(-first.getRoadWidth()) / 2.0);
        Vector2D secondNormal = secondVector.getNormal().normalised().scale((double)second.getRoadWidth() / 2.0);
        Point2D start1Point = firstPoint.plus(firstNormal);
        Line2D line1 = new Line2D(start1Point, firstVector);
        Point2D intersection = GeometryTools2D.getIntersectionPoint((Line2D)line1, (Line2D)(line2 = new Line2D(start2Point = secondPoint.plus(secondNormal), secondVector)));
        if (intersection == null) {
            intersection = centrePoint.plus(firstNormal);
        }
        first.setRightEnd(intersection);
        second.setLeftEnd(intersection);
        return intersection;
    }

    private void findRoadEdges(RoadAspect aspect, Point2D centrePoint) {
        LegacyNode farNode = aspect.getFarNode();
        Point2D roadPoint = new Point2D((double)farNode.getX(), (double)farNode.getY());
        Vector2D vector = centrePoint.minus(roadPoint);
        Vector2D leftNormal = vector.getNormal().normalised().scale((double)aspect.getRoadWidth() / 2.0);
        Vector2D rightNormal = leftNormal.scale(-1.0);
        Point2D left = roadPoint.plus(leftNormal);
        Point2D right = roadPoint.plus(rightNormal);
        aspect.setLeftEnd(left);
        aspect.setRightEnd(right);
    }

    private static class CounterClockwiseSort
    implements Comparator<RoadAspect> {
        private Point2D centre;

        public CounterClockwiseSort(Point2D centre) {
            this.centre = centre;
        }

        @Override
        public int compare(RoadAspect first, RoadAspect second) {
            double d2;
            double d1 = this.score(first);
            if (d1 < (d2 = this.score(second))) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
            return 0;
        }

        public double score(RoadAspect aspect) {
            LegacyNode node = aspect.getFarNode();
            Point2D point = new Point2D((double)node.getX(), (double)node.getY());
            Vector2D v = point.minus(this.centre);
            double sin = v.getX() / v.getLength();
            double cos = v.getY() / v.getLength();
            if (Double.isNaN(sin) || Double.isNaN(cos)) {
                System.out.println(v);
                System.out.println(v.getLength());
            }
            return this.convert(sin, cos);
        }

        private double convert(double sin, double cos) {
            if (sin >= 0.0 && cos >= 0.0) {
                return sin;
            }
            if (sin >= 0.0 && cos < 0.0) {
                return 2.0 - sin;
            }
            if (sin < 0.0 && cos < 0.0) {
                return 2.0 - sin;
            }
            if (sin < 0.0 && cos >= 0.0) {
                return 4.0 + sin;
            }
            throw new IllegalArgumentException("This should be impossible! What's going on? sin=" + sin + ", cos=" + cos);
        }
    }

    private static class RoadAspect {
        private boolean forward;
        private LegacyNode farNode;
        private RoadInfo info;
        private int width;

        RoadAspect(LegacyRoad road, LegacyNode intersection, LegacyMap map, RoadInfo info) {
            this.forward = intersection.getID() == road.getTail();
            this.farNode = map.getNode(this.forward ? road.getHead() : road.getTail());
            this.width = road.getWidth();
            this.info = info;
        }

        int getRoadWidth() {
            return this.width;
        }

        LegacyNode getFarNode() {
            return this.farNode;
        }

        void setLeftEnd(Point2D p) {
            if (this.forward) {
                this.info.setHeadLeft(p);
            } else {
                this.info.setTailRight(p);
            }
        }

        void setRightEnd(Point2D p) {
            if (this.forward) {
                this.info.setHeadRight(p);
            } else {
                this.info.setTailLeft(p);
            }
        }
    }
}

