/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import maps.MapTools;
import maps.ScaleConversion;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;

public class FixLatLongTool
extends AbstractTool {
    public FixLatLongTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Fix lat/long";
    }

    @Override
    public void activate() {
        double minX = this.editor.getMap().getMinX();
        double minY = this.editor.getMap().getMinY();
        double factor = 1.0 / MapTools.sizeOf1Metre(minX, minY);
        ScaleConversion c = new ScaleConversion(minX, minY, factor, factor);
        this.editor.getMap().convertCoordinates(c);
        this.editor.setChanged();
    }

    @Override
    public void deactivate() {
    }
}

