/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.entities;

import com.infomatiq.jsi.IntProcedure;
import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.SpatialIndex;
import com.infomatiq.jsi.rtree.RTree;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import rescuecore2.log.Logger;
import rescuecore2.misc.Pair;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.DefaultWorldModel;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;
import rescuecore2.worldmodel.WorldModelListener;

public class StandardWorldModel
extends DefaultWorldModel<StandardEntity> {
    private SpatialIndex index;
    private Map<StandardEntityURN, Collection<StandardEntity>> storedTypes = new EnumMap<StandardEntityURN, Collection<StandardEntity>>(StandardEntityURN.class);
    private Set<StandardEntity> unindexedEntities = new HashSet<StandardEntity>();
    private Map<Human, Rectangle> humanRectangles = new HashMap<Human, Rectangle>();
    private boolean indexed;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;

    public StandardWorldModel() {
        super(StandardEntity.class);
        this.addWorldModelListener(new AddRemoveListener());
        this.indexed = false;
    }

    public void merge(ChangeSet changeSet) {
        super.merge(changeSet);
        for (Map.Entry<Human, Rectangle> next : this.humanRectangles.entrySet()) {
            Human h = next.getKey();
            Rectangle r = next.getValue();
            this.index.delete(r, h.getID().getValue());
            r = this.makeRectangle(h);
            if (r == null) continue;
            this.index.add(r, h.getID().getValue());
            next.setValue(r);
        }
    }

    public void indexClass(StandardEntityURN ... urns) {
        for (StandardEntityURN urn : urns) {
            HashSet<StandardEntity> bucket = new HashSet<StandardEntity>();
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                StandardEntity next = (StandardEntity)((Object)i$.next());
                if (!next.getStandardURN().equals((Object)urn)) continue;
                bucket.add(next);
            }
            this.storedTypes.put(urn, bucket);
        }
    }

    public void index() {
        if (this.indexed && this.unindexedEntities.isEmpty()) {
            Logger.debug((String)"Not bothering with reindex: No entities are currently unindexed");
            return;
        }
        Logger.debug((String)"Re-indexing world model");
        long start = System.currentTimeMillis();
        this.index = new RTree();
        this.index.init(new Properties());
        this.humanRectangles.clear();
        this.unindexedEntities.clear();
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxY = Integer.MIN_VALUE;
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            StandardEntity next = (StandardEntity)((Object)i$.next());
            Rectangle r = this.makeRectangle(next);
            if (r == null) continue;
            this.index.add(r, next.getID().getValue());
            this.minX = Math.min(this.minX, (int)r.min[0]);
            this.maxX = Math.max(this.maxX, (int)r.max[0]);
            this.minY = Math.min(this.minY, (int)r.min[1]);
            this.maxY = Math.max(this.maxY, (int)r.max[1]);
            if (!(next instanceof Human)) continue;
            this.humanRectangles.put((Human)next, r);
        }
        long end = System.currentTimeMillis();
        Logger.debug((String)("Finished re-index. Took " + (end - start) + "ms"));
        this.indexed = true;
    }

    public Collection<StandardEntity> getObjectsInRange(EntityID entity, int range) {
        return this.getObjectsInRange((StandardEntity)this.getEntity(entity), range);
    }

    public Collection<StandardEntity> getObjectsInRange(StandardEntity entity, int range) {
        Pair<Integer, Integer> location = entity.getLocation((WorldModel<? extends StandardEntity>)this);
        if (location == null) {
            return new HashSet<StandardEntity>();
        }
        return this.getObjectsInRange((Integer)location.first(), (Integer)location.second(), range);
    }

    public Collection<StandardEntity> getObjectsInRange(int x, int y, int range) {
        if (!this.indexed) {
            this.index();
        }
        return this.getObjectsInRectangle(x - range, y - range, x + range, y + range);
    }

    public Collection<StandardEntity> getObjectsInRectangle(int x1, int y1, int x2, int y2) {
        if (!this.indexed) {
            this.index();
        }
        final HashSet<StandardEntity> result = new HashSet<StandardEntity>();
        Rectangle r = new Rectangle((float)x1, (float)y1, (float)x2, (float)y2);
        this.index.intersects(r, new IntProcedure(){

            public boolean execute(int id) {
                StandardEntity e = (StandardEntity)StandardWorldModel.this.getEntity(new EntityID(id));
                if (e != null) {
                    result.add(e);
                }
                return true;
            }
        });
        return result;
    }

    public Collection<StandardEntity> getEntitiesOfType(StandardEntityURN urn) {
        if (this.storedTypes.containsKey((Object)urn)) {
            return this.storedTypes.get((Object)urn);
        }
        this.indexClass(urn);
        return this.storedTypes.get((Object)urn);
    }

    public Collection<StandardEntity> getEntitiesOfType(StandardEntityURN ... urns) {
        HashSet<StandardEntity> result = new HashSet<StandardEntity>();
        for (StandardEntityURN urn : urns) {
            result.addAll(this.getEntitiesOfType(urn));
        }
        return result;
    }

    public int getDistance(EntityID first, EntityID second) {
        StandardEntity a = (StandardEntity)this.getEntity(first);
        StandardEntity b = (StandardEntity)this.getEntity(second);
        if (a == null || b == null) {
            return -1;
        }
        return this.getDistance(a, b);
    }

    public int getDistance(StandardEntity first, StandardEntity second) {
        Pair<Integer, Integer> a = first.getLocation((WorldModel<? extends StandardEntity>)this);
        Pair<Integer, Integer> b = second.getLocation((WorldModel<? extends StandardEntity>)this);
        if (a == null || b == null) {
            return -1;
        }
        return this.distance(a, b);
    }

    public Rectangle2D getBounds() {
        if (!this.indexed) {
            this.index();
        }
        return new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> getWorldBounds() {
        if (!this.indexed) {
            this.index();
        }
        Pair topLeft = new Pair((Object)this.minX, (Object)this.minY);
        Pair bottomRight = new Pair((Object)this.maxX, (Object)this.maxY);
        return new Pair((Object)topLeft, (Object)bottomRight);
    }

    public static StandardWorldModel createStandardWorldModel(WorldModel<? extends Entity> existing) {
        if (existing instanceof StandardWorldModel) {
            return (StandardWorldModel)existing;
        }
        final StandardWorldModel result = new StandardWorldModel();
        if (existing != null) {
            result.addEntities(existing.getAllEntities());
            existing.addWorldModelListener((WorldModelListener)new WorldModelListener<Entity>(){

                public void entityAdded(WorldModel<? extends Entity> model, Entity e) {
                    result.addEntity(e);
                }

                public void entityRemoved(WorldModel<? extends Entity> model, Entity e) {
                    if (e instanceof StandardEntity) {
                        result.removeEntity((Entity)((StandardEntity)e));
                    }
                }
            });
        }
        return result;
    }

    private Rectangle makeRectangle(StandardEntity e) {
        int x1 = Integer.MAX_VALUE;
        int x2 = Integer.MIN_VALUE;
        int y1 = Integer.MAX_VALUE;
        int y2 = Integer.MIN_VALUE;
        if (e instanceof Area) {
            int[] apexes = ((Area)e).getApexList();
            if (apexes.length == 0) {
                return null;
            }
            for (int i = 0; i < apexes.length - 1; i += 2) {
                x1 = Math.min(x1, apexes[i]);
                x2 = Math.max(x2, apexes[i]);
                y1 = Math.min(y1, apexes[i + 1]);
                y2 = Math.max(y2, apexes[i + 1]);
            }
        } else if (e instanceof Blockade) {
            int[] apexes = ((Blockade)e).getApexes();
            if (apexes.length == 0) {
                return null;
            }
            for (int i = 0; i < apexes.length - 1; i += 2) {
                x1 = Math.min(x1, apexes[i]);
                x2 = Math.max(x2, apexes[i]);
                y1 = Math.min(y1, apexes[i + 1]);
                y2 = Math.max(y2, apexes[i + 1]);
            }
        } else if (e instanceof Human) {
            Human h = (Human)e;
            Pair<Integer, Integer> location = h.getLocation((WorldModel<? extends StandardEntity>)this);
            if (location == null) {
                return null;
            }
            x1 = (Integer)location.first();
            x2 = (Integer)location.first();
            y1 = (Integer)location.second();
            y2 = (Integer)location.second();
        } else {
            return null;
        }
        return new Rectangle((float)x1, (float)y1, (float)x2, (float)y2);
    }

    private int distance(Pair<Integer, Integer> a, Pair<Integer, Integer> b) {
        return this.distance((Integer)a.first(), (Integer)a.second(), (Integer)b.first(), (Integer)b.second());
    }

    private int distance(int x1, int y1, int x2, int y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return (int)Math.hypot(dx, dy);
    }

    private class AddRemoveListener
    implements WorldModelListener<StandardEntity> {
        private AddRemoveListener() {
        }

        public void entityAdded(WorldModel<? extends StandardEntity> model, StandardEntity e) {
            StandardEntityURN type = e.getStandardURN();
            if (StandardWorldModel.this.storedTypes.containsKey((Object)type)) {
                Collection bucket = (Collection)StandardWorldModel.this.storedTypes.get((Object)type);
                bucket.add(e);
            }
            StandardWorldModel.this.unindexedEntities.add(e);
        }

        public void entityRemoved(WorldModel<? extends StandardEntity> model, StandardEntity e) {
            StandardEntityURN type = e.getStandardURN();
            if (StandardWorldModel.this.storedTypes.containsKey((Object)type)) {
                Collection bucket = (Collection)StandardWorldModel.this.storedTypes.get((Object)type);
                bucket.remove((Object)e);
            }
            StandardWorldModel.this.unindexedEntities.remove((Object)e);
        }
    }
}

