/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.kernel.comms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import rescuecore2.log.Logger;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.standard.kernel.comms.Channel;
import rescuecore2.standard.kernel.comms.InvalidMessageException;
import rescuecore2.standard.kernel.comms.Noise;
import rescuecore2.standard.messages.AKSpeak;
import rescuecore2.worldmodel.Entity;

public abstract class AbstractChannel
implements Channel {
    protected Collection<Entity> subscribers;
    protected int channelID;
    private Map<Entity, Collection<AKSpeak>> messagesForAgents;
    private Noise inputNoise;
    private Noise outputNoise;

    protected AbstractChannel(int channelID) {
        this.channelID = channelID;
        this.subscribers = new HashSet<Entity>();
        this.messagesForAgents = new LazyMap<Entity, Collection<AKSpeak>>(){

            public Collection<AKSpeak> createValue() {
                return new ArrayList<AKSpeak>();
            }
        };
        this.inputNoise = null;
        this.outputNoise = null;
    }

    @Override
    public void setInputNoise(Noise noise) {
        this.inputNoise = noise;
    }

    @Override
    public void setOutputNoise(Noise noise) {
        this.outputNoise = noise;
    }

    @Override
    public void timestep() {
        this.messagesForAgents.clear();
    }

    @Override
    public void addSubscriber(Entity a) {
        this.subscribers.add(a);
    }

    @Override
    public void removeSubscriber(Entity a) {
        this.subscribers.remove(a);
    }

    @Override
    public Collection<Entity> getSubscribers() {
        return this.subscribers;
    }

    @Override
    public Collection<AKSpeak> getMessagesForAgent(Entity agent) {
        Collection<AKSpeak> c = this.messagesForAgents.get(agent);
        return new ArrayList<AKSpeak>(c);
    }

    @Override
    public final void push(AKSpeak speak) throws InvalidMessageException {
        int channel = speak.getChannel();
        if (channel != this.channelID) {
            throw new InvalidMessageException("Tried to push '" + (Object)((Object)speak) + "' to channel " + this.channelID);
        }
        Logger.debug((String)("Pushing " + (Object)((Object)speak) + " through channel " + this.channelID));
        speak = this.applyInputNoise(speak);
        Logger.debug((String)("Input noise result: " + (Object)((Object)speak)));
        if (speak != null) {
            this.pushImpl(speak);
        }
    }

    protected abstract void pushImpl(AKSpeak var1) throws InvalidMessageException;

    protected void addMessageForAgent(Entity a, AKSpeak msg) {
        Logger.debug((String)("Adding message " + (Object)((Object)msg) + " for agent " + a));
        msg = this.applyOutputNoise(msg);
        Logger.debug((String)("Output noise result: " + (Object)((Object)msg)));
        if (msg != null) {
            Collection<AKSpeak> c = this.messagesForAgents.get(a);
            c.add(msg);
        }
    }

    protected void addMessageForSubscribers(AKSpeak msg) {
        for (Entity e : this.subscribers) {
            this.addMessageForAgent(e, msg);
        }
    }

    protected boolean isSubscribed(Entity e) {
        return this.subscribers.contains(e);
    }

    private AKSpeak applyInputNoise(AKSpeak msg) {
        if (this.inputNoise != null) {
            return this.inputNoise.applyNoise(msg);
        }
        return msg;
    }

    private AKSpeak applyOutputNoise(AKSpeak msg) {
        if (this.outputNoise != null) {
            return this.outputNoise.applyNoise(msg);
        }
        return msg;
    }
}

