/*
 * Decompiled with CFR 0.152.
 */
package traffic3.simulator;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.GaussianGenerator;
import rescuecore2.GUIComponent;
import rescuecore2.log.Logger;
import rescuecore2.messages.control.KSCommands;
import rescuecore2.messages.control.KSUpdate;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.standard.components.StandardSimulator;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.standard.entities.Civilian;
import rescuecore2.standard.entities.Edge;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.PoliceForce;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.messages.AKClear;
import rescuecore2.standard.messages.AKExtinguish;
import rescuecore2.standard.messages.AKLoad;
import rescuecore2.standard.messages.AKMove;
import rescuecore2.standard.messages.AKRescue;
import rescuecore2.standard.messages.AKUnload;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.WorldModel;
import rescuecore2.worldmodel.WorldModelListener;
import traffic3.manager.TrafficManager;
import traffic3.objects.TrafficAgent;
import traffic3.objects.TrafficArea;
import traffic3.objects.TrafficBlockade;
import traffic3.simulator.PathElement;
import traffic3.simulator.TrafficConstants;
import traffic3.simulator.TrafficSimulatorGUI;

public class TrafficSimulator
extends StandardSimulator
implements GUIComponent {
    private static final double STEP_TIME_MS = 100.0;
    private static final double REAL_TIME_S = 60.0;
    private static final int MICROSTEPS = 600;
    private static final int RESCUE_AGENT_RADIUS = 500;
    private static final int CIVILIAN_RADIUS = 200;
    private static final double RESCUE_AGENT_VELOCITY_MEAN = 0.7;
    private static final double RESCUE_AGENT_VELOCITY_SD = 0.1;
    private static final double CIVILIAN_VELOCITY_MEAN = 0.2;
    private static final double CIVILIAN_VELOCITY_SD = 0.002;
    private static final Color FIRE_BRIGADE_COLOUR = Color.RED;
    private static final Color POLICE_FORCE_COLOUR = Color.BLUE;
    private static final Color AMBULANCE_TEAM_COLOUR = Color.WHITE;
    private static final Color CIVILIAN_COLOUR = Color.GREEN;
    private TrafficSimulatorGUI gui;
    private TrafficManager manager = new TrafficManager();

    public TrafficSimulator() {
        this.gui = new TrafficSimulatorGUI(this.manager);
    }

    public JComponent getGUIComponent() {
        return this.gui;
    }

    public String getGUIComponentName() {
        return "Traffic simulator";
    }

    protected void postConnect() {
        TrafficConstants.init(this.config);
        this.manager.clear();
        for (StandardEntity next : (StandardWorldModel)this.model) {
            if (!(next instanceof Area)) continue;
            this.convertAreaToTrafficArea((Area)next);
        }
        GaussianGenerator agentVelocityGenerator = new GaussianGenerator(0.7, 0.1, this.config.getRandom());
        GaussianGenerator civilianVelocityGenerator = new GaussianGenerator(0.2, 0.002, this.config.getRandom());
        for (StandardEntity next : (StandardWorldModel)this.model) {
            if (next instanceof Human) {
                this.convertHuman((Human)next, (NumberGenerator<Double>)agentVelocityGenerator, (NumberGenerator<Double>)civilianVelocityGenerator);
            }
            if (!(next instanceof Blockade)) continue;
            this.convertBlockade((Blockade)next);
        }
        ((StandardWorldModel)this.model).addWorldModelListener((WorldModelListener)new WorldModelListener<StandardEntity>(){

            public void entityAdded(WorldModel<? extends StandardEntity> model, StandardEntity e) {
                if (e instanceof Blockade) {
                    TrafficSimulator.this.convertBlockade((Blockade)e);
                }
            }

            public void entityRemoved(WorldModel<? extends StandardEntity> model, StandardEntity e) {
                if (e instanceof Blockade) {
                    Blockade b = (Blockade)e;
                    TrafficBlockade block = TrafficSimulator.this.manager.getTrafficBlockade(b);
                    block.getArea().removeBlockade(block);
                    TrafficSimulator.this.manager.remove(block);
                }
            }
        });
        this.gui.initialise();
        this.manager.cacheInformation((StandardWorldModel)this.model);
    }

    protected void processCommands(KSCommands c, ChangeSet changes) {
        long start = System.currentTimeMillis();
        Logger.info((String)("Timestep " + c.getTime()));
        for (TrafficArea next : this.manager.getAreas()) {
            next.clearBlockadeCache();
        }
        for (TrafficAgent agent : this.manager.getAgents()) {
            agent.clearPath();
            agent.clearPositionHistory();
            agent.setMobile(true);
        }
        for (TrafficArea next : c.getCommands()) {
            if (next instanceof AKMove) {
                this.handleMove((AKMove)next);
            }
            if (next instanceof AKLoad) {
                this.handleLoad((AKLoad)next, changes);
            }
            if (next instanceof AKUnload) {
                this.handleUnload((AKUnload)next, changes);
            }
            if (next instanceof AKRescue) {
                this.handleRescue((AKRescue)next, changes);
            }
            if (next instanceof AKClear) {
                this.handleClear((AKClear)next, changes);
            }
            if (!(next instanceof AKExtinguish)) continue;
            this.handleExtinguish((AKExtinguish)next, changes);
        }
        for (TrafficArea next : (StandardWorldModel)this.model) {
            if (!(next instanceof Human)) continue;
            Human h = (Human)next;
            if (h.isHPDefined() && h.getHP() <= 0) {
                Logger.debug((String)("Agent " + h + " is dead"));
                this.manager.getTrafficAgent(h).setMobile(false);
            }
            if (!h.isPositionDefined() || !(((StandardWorldModel)this.model).getEntity(h.getPosition()) instanceof AmbulanceTeam)) continue;
            Logger.debug((String)("Agent " + h + " is in an ambulance"));
            this.manager.getTrafficAgent(h).setMobile(false);
        }
        this.timestep();
        for (TrafficAgent agent : this.manager.getAgents()) {
            Human human = agent.getHuman();
            if (!agent.isMobile()) {
                human.undefinePositionHistory();
                human.setTravelDistance(0);
                changes.addChange((Entity)human, (Property)human.getPositionHistoryProperty());
                changes.addChange((Entity)human, (Property)human.getTravelDistanceProperty());
                continue;
            }
            Point2D[] history = agent.getPositionHistory().toArray(new Point2D[0]);
            int[] historyArray = new int[history.length * 2];
            for (int i = 0; i < history.length; ++i) {
                historyArray[i * 2] = (int)history[i].getX();
                historyArray[i * 2 + 1] = (int)history[i].getY();
            }
            double x = agent.getX();
            double y = agent.getY();
            TrafficArea location = agent.getArea();
            if (location != null) {
                human.setPosition(location.getArea().getID());
                changes.addChange((Entity)human, (Property)human.getPositionProperty());
            }
            human.setX((int)x);
            human.setY((int)y);
            human.setPositionHistory(historyArray);
            human.setTravelDistance((int)agent.getTravelDistance());
            changes.addChange((Entity)human, (Property)human.getXProperty());
            changes.addChange((Entity)human, (Property)human.getYProperty());
            changes.addChange((Entity)human, (Property)human.getPositionHistoryProperty());
            changes.addChange((Entity)human, (Property)human.getTravelDistanceProperty());
        }
        long end = System.currentTimeMillis();
        Logger.info((String)("Timestep " + c.getTime() + " took " + (end - start) + " ms"));
    }

    protected void handleUpdate(KSUpdate u) {
        super.handleUpdate(u);
    }

    private void convertAreaToTrafficArea(Area area) {
        this.manager.register(new TrafficArea(area));
    }

    private void convertBlockade(Blockade b) {
        Logger.debug((String)("Converting blockade: " + b.getFullDescription()));
        Area a = (Area)((StandardWorldModel)this.model).getEntity(b.getPosition());
        Logger.debug((String)("Area: " + a));
        TrafficArea area = this.manager.getTrafficArea(a);
        Logger.debug((String)("Traffic area: " + area));
        TrafficBlockade block = new TrafficBlockade(b, area);
        this.manager.register(block);
        area.addBlockade(block);
    }

    private void convertHuman(Human h, NumberGenerator<Double> agentVelocityGenerator, NumberGenerator<Double> civilianVelocityGenerator) {
        double radius = 0.0;
        double velocityLimit = 0.0;
        if (h instanceof FireBrigade || h instanceof PoliceForce || h instanceof AmbulanceTeam) {
            radius = 500.0;
            velocityLimit = (Double)agentVelocityGenerator.nextValue();
        } else if (h instanceof Civilian) {
            radius = 200.0;
            velocityLimit = (Double)civilianVelocityGenerator.nextValue();
        } else {
            throw new IllegalArgumentException("Unrecognised agent type: " + h + " (" + h.getClass().getName() + ")");
        }
        TrafficAgent agent = new TrafficAgent(h, this.manager, radius, velocityLimit);
        agent.setLocation(h.getX(), h.getY());
        this.manager.register(agent);
    }

    private void handleMove(AKMove move) {
        Human human = (Human)((StandardWorldModel)this.model).getEntity(move.getAgentID());
        TrafficAgent agent = this.manager.getTrafficAgent(human);
        EntityID current = human.getPosition();
        if (current == null) {
            Logger.warn((String)"Rejecting move: Agent position is not defined");
            return;
        }
        Entity currentEntity = ((StandardWorldModel)this.model).getEntity(human.getPosition());
        if (!(currentEntity instanceof Area)) {
            Logger.warn((String)("Rejecting move: Agent position is not an area: " + currentEntity));
            return;
        }
        Area currentArea = (Area)currentEntity;
        List list = move.getPath();
        ArrayList<PathElement> steps = new ArrayList<PathElement>();
        for (EntityID next : list) {
            if (next.equals((Object)current)) continue;
            Entity e = ((StandardWorldModel)this.model).getEntity(next);
            if (!(e instanceof Area)) {
                Logger.warn((String)("Rejecting move: Entity ID " + next + " is not an area: " + e));
                return;
            }
            Edge edge = currentArea.getEdgeTo(next);
            if (edge == null) {
                Logger.warn((String)("Rejecting move: Entity ID " + next + " is not adjacent to " + currentArea));
                return;
            }
            Area a = (Area)e;
            int x = (edge.getStartX() + edge.getEndX()) / 2;
            int y = (edge.getStartY() + edge.getEndY()) / 2;
            Point2D edgePoint = new Point2D((double)x, (double)y);
            Point2D centrePoint = new Point2D((double)currentArea.getX(), (double)currentArea.getY());
            steps.add(new PathElement(next, edgePoint, centrePoint));
            current = next;
            currentArea = a;
        }
        int targetX = move.getDestinationX();
        int targetY = move.getDestinationY();
        if (targetX == -1 && targetY == -1) {
            targetX = currentArea.getX();
            targetY = currentArea.getY();
        } else if (list.isEmpty()) {
            Logger.warn((String)"Rejecting move: Path is empty");
            return;
        }
        steps.add(new PathElement(current, new Point2D((double)targetX, (double)targetY), new Point2D[0]));
        agent.setPath(steps);
    }

    private Civilian handleLoad(AKLoad load, ChangeSet changes) {
        EntityID agentID = load.getAgentID();
        EntityID targetID = load.getTarget();
        Entity agent = ((StandardWorldModel)this.model).getEntity(agentID);
        Entity target = ((StandardWorldModel)this.model).getEntity(targetID);
        if (agent == null) {
            Logger.warn((String)("Rejecting load command from agent " + agentID + ": agent does not exist"));
            return null;
        }
        if (!(agent instanceof AmbulanceTeam)) {
            Logger.warn((String)("Rejecting load command from agent " + agentID + ": agent type is " + agent.getURN()));
            return null;
        }
        if (target == null) {
            Logger.warn((String)("Rejecting load command from agent " + agentID + ": target does not exist " + targetID));
            return null;
        }
        if (!(target instanceof Civilian)) {
            Logger.warn((String)("Rejecting load command from agent " + agentID + ": target " + targetID + " is of type " + target.getURN()));
            return null;
        }
        AmbulanceTeam at = (AmbulanceTeam)agent;
        Civilian h = (Civilian)target;
        if (at.isHPDefined() && at.getHP() <= 0) {
            Logger.warn((String)("Rejecting load command from agent " + agentID + ": agent is dead"));
            return null;
        }
        if (at.isBuriednessDefined() && at.getBuriedness() > 0) {
            Logger.warn((String)("Rejecting load command from agent " + agentID + ": agent is buried"));
            return null;
        }
        if (h.isBuriednessDefined() && h.getBuriedness() > 0) {
            Logger.warn((String)("Rejecting load command from agent " + agentID + ": target " + targetID + " is buried"));
            return null;
        }
        if (!(h.isPositionDefined() && at.isPositionDefined() && h.getPosition().equals((Object)at.getPosition()))) {
            Logger.warn((String)("Rejecting load command from agent " + agentID + ": target is non-adjacent " + targetID));
            return null;
        }
        if (h.getID().equals((Object)at.getID())) {
            Logger.warn((String)("Rejecting load command from agent " + agentID + ": tried to load self"));
            return null;
        }
        for (StandardEntity e : ((StandardWorldModel)this.model).getEntitiesOfType(StandardEntityURN.CIVILIAN)) {
            Civilian c = (Civilian)e;
            if (!c.isPositionDefined() || !agentID.equals((Object)c.getPosition())) continue;
            Logger.warn((String)("Rejecting load command from agent " + agentID + ": agent already has civilian " + c.getID() + " loaded"));
            return null;
        }
        h.setPosition(agentID);
        h.undefineX();
        h.undefineY();
        changes.addChange((Entity)h, (Property)h.getPositionProperty());
        changes.addChange((Entity)h, (Property)h.getXProperty());
        changes.addChange((Entity)h, (Property)h.getYProperty());
        this.manager.getTrafficAgent((Human)at).setMobile(false);
        this.manager.getTrafficAgent((Human)h).setMobile(false);
        Logger.debug((String)(at + " loaded " + h));
        return h;
    }

    private Civilian handleUnload(AKUnload unload, ChangeSet changes) {
        EntityID agentID = unload.getAgentID();
        Entity agent = ((StandardWorldModel)this.model).getEntity(agentID);
        if (agent == null) {
            Logger.warn((String)("Rejecting unload command from agent " + agentID + ": agent does not exist"));
            return null;
        }
        if (!(agent instanceof AmbulanceTeam)) {
            Logger.warn((String)("Rejecting unload command from agent " + agentID + ": agent type is " + agent.getURN()));
            return null;
        }
        AmbulanceTeam at = (AmbulanceTeam)agent;
        if (!(at.isPositionDefined() && at.isXDefined() && at.isYDefined())) {
            Logger.warn((String)("Rejecting unload command from agent " + agentID + ": could not locate agent"));
            return null;
        }
        if (at.isHPDefined() && at.getHP() <= 0) {
            Logger.warn((String)("Rejecting unload command from agent " + agentID + ": agent is dead"));
            return null;
        }
        if (at.isBuriednessDefined() && at.getBuriedness() > 0) {
            Logger.warn((String)("Rejecting unload command from agent " + agentID + ": agent is buried"));
            return null;
        }
        Civilian target = null;
        Logger.debug((String)("Looking for civilian carried by " + agentID));
        for (StandardEntity e : ((StandardWorldModel)this.model).getEntitiesOfType(StandardEntityURN.CIVILIAN)) {
            Civilian c = (Civilian)e;
            Logger.debug((String)(c + " is at " + c.getPosition()));
            if (!c.isPositionDefined() || !agentID.equals((Object)c.getPosition())) continue;
            target = c;
            Logger.debug((String)("Found civilian " + c));
            break;
        }
        if (target == null) {
            Logger.warn((String)("Rejecting unload command from agent " + agentID + ": agent is not carrying any civilians"));
            return null;
        }
        target.setPosition(at.getPosition());
        target.setX(at.getX());
        target.setY(at.getY());
        changes.addChange(target, (Property)target.getPositionProperty());
        changes.addChange(target, (Property)target.getXProperty());
        changes.addChange((Entity)target, (Property)target.getYProperty());
        for (TrafficAgent trafficAgent : this.manager.getAgents()) {
            if (trafficAgent.getHuman() != target) continue;
            trafficAgent.setLocation(at.getX(), at.getY());
            trafficAgent.clearPath();
        }
        this.manager.getTrafficAgent((Human)at).setMobile(false);
        this.manager.getTrafficAgent((Human)target).setMobile(false);
        Logger.debug((String)(at + " unloaded " + target));
        return target;
    }

    private void handleClear(AKClear clear, ChangeSet changes) {
        EntityID agentID = clear.getAgentID();
        Entity agent = ((StandardWorldModel)this.model).getEntity(agentID);
        if (agent instanceof Human) {
            this.manager.getTrafficAgent((Human)agent).setMobile(false);
            Logger.debug((String)(agent + " is clearing"));
        }
    }

    private void handleRescue(AKRescue rescue, ChangeSet changes) {
        EntityID agentID = rescue.getAgentID();
        Entity agent = ((StandardWorldModel)this.model).getEntity(agentID);
        if (agent instanceof Human) {
            this.manager.getTrafficAgent((Human)agent).setMobile(false);
            Logger.debug((String)(agent + " is rescueing"));
        }
    }

    private void handleExtinguish(AKExtinguish ex, ChangeSet changes) {
        EntityID agentID = ex.getAgentID();
        Entity agent = ((StandardWorldModel)this.model).getEntity(agentID);
        if (agent instanceof Human) {
            this.manager.getTrafficAgent((Human)agent).setMobile(false);
            Logger.debug((String)(agent + " is extinguishing"));
        }
    }

    private void timestep() {
        long start = System.currentTimeMillis();
        for (TrafficAgent agent : this.manager.getAgents()) {
            agent.beginTimestep();
        }
        long pre = System.currentTimeMillis();
        Logger.debug((String)"Running 600 microsteps");
        for (int i = 0; i < 600; ++i) {
            this.microstep();
        }
        long post = System.currentTimeMillis();
        for (TrafficAgent agent : this.manager.getAgents()) {
            agent.endTimestep();
        }
        long end = System.currentTimeMillis();
        if (this.manager.getAgents().size() != 0) {
            Logger.debug((String)("Pre-timestep took " + (pre - start) + " ms (average " + (pre - start) / (long)this.manager.getAgents().size() + "ms per agent)"));
            Logger.debug((String)("Microsteps took: " + (post - pre) + "ms (average " + (post - pre) / 600L + "ms)"));
            Logger.debug((String)("Post-timestep took " + (end - post) + " ms (average " + (end - post) / (long)this.manager.getAgents().size() + "ms per agent)"));
        }
        Logger.debug((String)("Total time: " + (end - start) + "ms"));
    }

    private void microstep() {
        for (TrafficAgent agent : this.manager.getAgents()) {
            agent.step(100.0);
        }
        this.gui.refresh();
    }
}

