/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.entities;

import rescuecore2.misc.Pair;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardPropertyURN;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.WorldModel;
import rescuecore2.worldmodel.properties.EntityRefProperty;
import rescuecore2.worldmodel.properties.IntArrayProperty;
import rescuecore2.worldmodel.properties.IntProperty;

public abstract class Human
extends StandardEntity {
    private IntProperty x;
    private IntProperty y;
    private EntityRefProperty position;
    private IntArrayProperty positionHistory;
    private IntProperty travelDistance;
    private IntProperty direction;
    private IntProperty stamina;
    private IntProperty hp;
    private IntProperty damage;
    private IntProperty buriedness;

    protected Human(EntityID id) {
        super(id);
        this.x = new IntProperty((Enum)StandardPropertyURN.X);
        this.y = new IntProperty((Enum)StandardPropertyURN.Y);
        this.travelDistance = new IntProperty((Enum)StandardPropertyURN.TRAVEL_DISTANCE);
        this.position = new EntityRefProperty((Enum)StandardPropertyURN.POSITION);
        this.positionHistory = new IntArrayProperty((Enum)StandardPropertyURN.POSITION_HISTORY);
        this.direction = new IntProperty((Enum)StandardPropertyURN.DIRECTION);
        this.stamina = new IntProperty((Enum)StandardPropertyURN.STAMINA);
        this.hp = new IntProperty((Enum)StandardPropertyURN.HP);
        this.damage = new IntProperty((Enum)StandardPropertyURN.DAMAGE);
        this.buriedness = new IntProperty((Enum)StandardPropertyURN.BURIEDNESS);
        this.registerProperties(new Property[]{this.x, this.y, this.position, this.positionHistory, this.travelDistance, this.direction, this.stamina, this.hp, this.damage, this.buriedness});
    }

    public Human(Human other) {
        super(other);
        this.x = new IntProperty(other.x);
        this.y = new IntProperty(other.y);
        this.travelDistance = new IntProperty(other.travelDistance);
        this.position = new EntityRefProperty(other.position);
        this.positionHistory = new IntArrayProperty(other.positionHistory);
        this.direction = new IntProperty(other.direction);
        this.stamina = new IntProperty(other.stamina);
        this.hp = new IntProperty(other.hp);
        this.damage = new IntProperty(other.damage);
        this.buriedness = new IntProperty(other.buriedness);
        this.registerProperties(new Property[]{this.x, this.y, this.position, this.positionHistory, this.travelDistance, this.direction, this.stamina, this.hp, this.damage, this.buriedness});
    }

    public Property getProperty(String urn) {
        StandardPropertyURN type;
        try {
            type = StandardPropertyURN.fromString(urn);
        }
        catch (IllegalArgumentException e) {
            return super.getProperty(urn);
        }
        switch (type) {
            case POSITION: {
                return this.position;
            }
            case POSITION_HISTORY: {
                return this.positionHistory;
            }
            case DIRECTION: {
                return this.direction;
            }
            case STAMINA: {
                return this.stamina;
            }
            case HP: {
                return this.hp;
            }
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case DAMAGE: {
                return this.damage;
            }
            case BURIEDNESS: {
                return this.buriedness;
            }
            case TRAVEL_DISTANCE: {
                return this.travelDistance;
            }
        }
        return super.getProperty(urn);
    }

    @Override
    public Pair<Integer, Integer> getLocation(WorldModel<? extends StandardEntity> world) {
        if (this.x.isDefined() && this.y.isDefined()) {
            return new Pair((Object)this.x.getValue(), (Object)this.y.getValue());
        }
        if (this.position.isDefined()) {
            EntityID pos = this.getPosition();
            StandardEntity e = (StandardEntity)world.getEntity(pos);
            return e.getLocation(world);
        }
        return null;
    }

    public EntityRefProperty getPositionProperty() {
        return this.position;
    }

    public EntityID getPosition() {
        return this.position.getValue();
    }

    public void setPosition(EntityID position) {
        this.position.setValue(position);
    }

    public boolean isPositionDefined() {
        return this.position.isDefined();
    }

    public void undefinePosition() {
        this.position.undefine();
    }

    public IntArrayProperty getPositionHistoryProperty() {
        return this.positionHistory;
    }

    public int[] getPositionHistory() {
        return this.positionHistory.getValue();
    }

    public void setPositionHistory(int[] history) {
        this.positionHistory.setValue(history);
    }

    public boolean isPositionHistoryDefined() {
        return this.positionHistory.isDefined();
    }

    public void undefinePositionHistory() {
        this.positionHistory.undefine();
    }

    public IntProperty getDirectionProperty() {
        return this.direction;
    }

    public int getDirection() {
        return this.direction.getValue();
    }

    public void setDirection(int direction) {
        this.direction.setValue(direction);
    }

    public boolean isDirectionDefined() {
        return this.direction.isDefined();
    }

    public void undefineDirection() {
        this.direction.undefine();
    }

    public IntProperty getStaminaProperty() {
        return this.stamina;
    }

    public int getStamina() {
        return this.stamina.getValue();
    }

    public void setStamina(int stamina) {
        this.stamina.setValue(stamina);
    }

    public boolean isStaminaDefined() {
        return this.stamina.isDefined();
    }

    public void undefineStamina() {
        this.stamina.undefine();
    }

    public IntProperty getHPProperty() {
        return this.hp;
    }

    public int getHP() {
        return this.hp.getValue();
    }

    public void setHP(int newHP) {
        this.hp.setValue(newHP);
    }

    public boolean isHPDefined() {
        return this.hp.isDefined();
    }

    public void undefineHP() {
        this.hp.undefine();
    }

    public IntProperty getDamageProperty() {
        return this.damage;
    }

    public int getDamage() {
        return this.damage.getValue();
    }

    public void setDamage(int damage) {
        this.damage.setValue(damage);
    }

    public boolean isDamageDefined() {
        return this.damage.isDefined();
    }

    public void undefineDamage() {
        this.damage.undefine();
    }

    public IntProperty getBuriednessProperty() {
        return this.buriedness;
    }

    public int getBuriedness() {
        return this.buriedness.getValue();
    }

    public void setBuriedness(int buriedness) {
        this.buriedness.setValue(buriedness);
    }

    public boolean isBuriednessDefined() {
        return this.buriedness.isDefined();
    }

    public void undefineBuriedness() {
        this.buriedness.undefine();
    }

    public IntProperty getXProperty() {
        return this.x;
    }

    public int getX() {
        return this.x.getValue();
    }

    public void setX(int x) {
        this.x.setValue(x);
    }

    public boolean isXDefined() {
        return this.x.isDefined();
    }

    public void undefineX() {
        this.x.undefine();
    }

    public IntProperty getYProperty() {
        return this.y;
    }

    public int getY() {
        return this.y.getValue();
    }

    public void setY(int y) {
        this.y.setValue(y);
    }

    public boolean isYDefined() {
        return this.y.isDefined();
    }

    public void undefineY() {
        this.y.undefine();
    }

    public IntProperty getTravelDistanceProperty() {
        return this.travelDistance;
    }

    public int getTravelDistance() {
        return this.travelDistance.getValue();
    }

    public void setTravelDistance(int d) {
        this.travelDistance.setValue(d);
    }

    public boolean isTravelDistanceDefined() {
        return this.travelDistance.isDefined();
    }

    public void undefineTravelDistance() {
        this.travelDistance.undefine();
    }

    public StandardEntity getPosition(WorldModel<? extends StandardEntity> model) {
        if (!this.position.isDefined()) {
            return null;
        }
        return (StandardEntity)model.getEntity(this.position.getValue());
    }

    public void setPosition(EntityID newPosition, int newX, int newY) {
        this.position.setValue(newPosition);
        this.x.setValue(newX);
        this.y.setValue(newY);
    }

    public int getBuriedness2() {
        int res = 0;
        if (this.buriedness.isDefined()) {
            res = this.buriedness.getValue();
        }
        return res;
    }

    public int getHP2() {
        int res = 10000;
        if (this.hp.isDefined()) {
            res = this.hp.getValue();
        }
        return res;
    }
}

