/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.misc.Pair;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.Civilian;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.view.StandardEntityViewLayer;
import rescuecore2.view.Icons;
import rescuecore2.worldmodel.WorldModel;

public class HumanLayer
extends StandardEntityViewLayer<Human> {
    private static final int SIZE = 10;
    private static final int HP_MAX = 10000;
    private static final int HP_INJURED = 7500;
    private static final int HP_CRITICAL = 1000;
    private static final String ICON_SIZE_KEY = "view.standard.human.icons.size";
    private static final String USE_ICONS_KEY = "view.standard.human.icons.use";
    private static final int DEFAULT_ICON_SIZE = 32;
    private static final HumanSorter HUMAN_SORTER = new HumanSorter();
    private static final Color CIVILIAN_COLOUR = Color.GREEN;
    private static final Color FIRE_BRIGADE_COLOUR = Color.RED;
    private static final Color POLICE_FORCE_COLOUR = Color.BLUE;
    private static final Color AMBULANCE_TEAM_COLOUR = Color.WHITE;
    private static final Color DEAD_COLOUR = Color.BLACK;
    private int iconSize = 32;
    private Map<String, Map<State, Icon>> icons;
    private boolean useIcons;
    private Action useIconsAction;

    public HumanLayer() {
        super(Human.class);
    }

    public void initialise(Config config) {
        this.iconSize = config.getIntValue(ICON_SIZE_KEY, 32);
        this.icons = new HashMap<String, Map<State, Icon>>();
        this.useIcons = config.getBooleanValue(USE_ICONS_KEY, false);
        this.icons.put(StandardEntityURN.FIRE_BRIGADE.toString(), this.generateIconMap("FireBrigade"));
        this.icons.put(StandardEntityURN.AMBULANCE_TEAM.toString(), this.generateIconMap("AmbulanceTeam"));
        this.icons.put(StandardEntityURN.POLICE_FORCE.toString(), this.generateIconMap("PoliceForce"));
        this.icons.put(StandardEntityURN.CIVILIAN.toString() + "-Male", this.generateIconMap("Civilian-Male"));
        this.icons.put(StandardEntityURN.CIVILIAN.toString() + "-Female", this.generateIconMap("Civilian-Female"));
        this.useIconsAction = new UseIconsAction();
    }

    public String getName() {
        return "Humans";
    }

    @Override
    public Shape render(Human h, Graphics2D g, ScreenTransform t) {
        RectangularShape shape;
        Icon icon;
        if (h.isPositionDefined() && this.world.getEntity(h.getPosition()) instanceof AmbulanceTeam) {
            return null;
        }
        Pair<Integer, Integer> location = this.getLocation(h);
        if (location == null) {
            return null;
        }
        int x = t.xToScreen((double)((Integer)location.first()).intValue());
        int y = t.yToScreen((double)((Integer)location.second()).intValue());
        Icon icon2 = icon = this.useIcons ? this.getIcon(h) : null;
        if (icon == null) {
            shape = new Ellipse2D.Double(x - 5, y - 5, 10.0, 10.0);
            g.setColor(this.adjustColour(this.getColour(h), h.getHP()));
            g.fill(shape);
        } else {
            shape = new Rectangle2D.Double(x -= icon.getIconWidth() / 2, y -= icon.getIconHeight() / 2, icon.getIconWidth(), icon.getIconHeight());
            icon.paintIcon(null, g, x, y);
        }
        return shape;
    }

    public List<JMenuItem> getPopupMenuItems() {
        ArrayList<JMenuItem> result = new ArrayList<JMenuItem>();
        result.add(new JMenuItem(this.useIconsAction));
        return result;
    }

    @Override
    protected void postView() {
        Collections.sort(this.entities, HUMAN_SORTER);
    }

    protected Pair<Integer, Integer> getLocation(Human h) {
        return h.getLocation((WorldModel<? extends StandardEntity>)this.world);
    }

    private Map<State, Icon> generateIconMap(String type) {
        EnumMap<State, Icon> result = new EnumMap<State, Icon>(State.class);
        for (State state : State.values()) {
            String resourceName = "rescuecore2/standard/view/" + type + "-" + state.toString() + "-" + this.iconSize + "x" + this.iconSize + ".png";
            URL resource = HumanLayer.class.getClassLoader().getResource(resourceName);
            if (resource == null) {
                Logger.warn((String)("Couldn't find resource: " + resourceName));
                continue;
            }
            result.put(state, new ImageIcon(resource));
        }
        return result;
    }

    private Color getColour(Human h) {
        switch (h.getStandardURN()) {
            case CIVILIAN: {
                return CIVILIAN_COLOUR;
            }
            case FIRE_BRIGADE: {
                return FIRE_BRIGADE_COLOUR;
            }
            case AMBULANCE_TEAM: {
                return AMBULANCE_TEAM_COLOUR;
            }
            case POLICE_FORCE: {
                return POLICE_FORCE_COLOUR;
            }
        }
        throw new IllegalArgumentException("Don't know how to draw humans of type " + (Object)((Object)h.getStandardURN()));
    }

    private Color adjustColour(Color c, int hp) {
        if (hp == 0) {
            return DEAD_COLOUR;
        }
        if (hp < 1000) {
            c = c.darker();
        }
        if (hp < 7500) {
            c = c.darker();
        }
        if (hp < 10000) {
            c = c.darker();
        }
        return c;
    }

    private Icon getIcon(Human h) {
        State state = this.getState(h);
        Map<State, Icon> iconMap = null;
        switch (h.getStandardURN()) {
            case CIVILIAN: {
                boolean male;
                boolean bl = male = h.getID().getValue() % 2 == 0;
                if (male) {
                    iconMap = this.icons.get(StandardEntityURN.CIVILIAN.toString() + "-Male");
                    break;
                }
                iconMap = this.icons.get(StandardEntityURN.CIVILIAN.toString() + "-Female");
                break;
            }
            default: {
                iconMap = this.icons.get(h.getStandardURN().toString());
            }
        }
        if (iconMap == null) {
            return null;
        }
        return iconMap.get((Object)state);
    }

    private State getState(Human h) {
        int hp = h.getHP();
        if (hp <= 0) {
            return State.DEAD;
        }
        if (hp <= 1000) {
            return State.CRITICAL;
        }
        if (hp <= 7500) {
            return State.INJURED;
        }
        return State.HEALTHY;
    }

    private final class UseIconsAction
    extends AbstractAction {
        public UseIconsAction() {
            super("Use icons");
            this.putValue("SwingSelectedKey", HumanLayer.this.useIcons);
            this.putValue("SmallIcon", HumanLayer.this.useIcons ? Icons.TICK : Icons.CROSS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HumanLayer.this.useIcons = !HumanLayer.this.useIcons;
            this.putValue("SwingSelectedKey", HumanLayer.this.useIcons);
            this.putValue("SmallIcon", HumanLayer.this.useIcons ? Icons.TICK : Icons.CROSS);
            HumanLayer.this.component.repaint();
        }
    }

    private static final class HumanSorter
    implements Comparator<Human>,
    Serializable {
        private HumanSorter() {
        }

        @Override
        public int compare(Human h1, Human h2) {
            if (h1 instanceof Civilian && !(h2 instanceof Civilian)) {
                return -1;
            }
            if (h2 instanceof Civilian && !(h1 instanceof Civilian)) {
                return 1;
            }
            return h1.getID().getValue() - h2.getID().getValue();
        }
    }

    private static enum State {
        HEALTHY{

            public String toString() {
                return "Healthy";
            }
        }
        ,
        INJURED{

            public String toString() {
                return "Injured";
            }
        }
        ,
        CRITICAL{

            public String toString() {
                return "Critical";
            }
        }
        ,
        DEAD{

            public String toString() {
                return "Dead";
            }
        };

    }
}

